<?php 
/* Template Name: Portfolio List */

// Fetch the Portfolio Categories
$cat_list = get_terms("portfolio-category", "orderby=count&hide_empty=0");
$parentpage = get_template_link("portfolio.php");
$portfolio = new WP_Query ("post_type=portfolio&showposts=-1");
$layout = get_post_meta($post->ID, "layout", true);
if($layout == "one-column") :
	$nextul = 1;
elseif($layout == "two-column") :
	$nextul = 2;
elseif($layout == "three-column") :
	$nextul = 3;
else :
	$nextul = 4;
endif;
$i = 1; 
get_header(); ?>
<h3 class="section-title"><?php the_title(); ?></h3>

<?php if ($cat_list != "") : ?>
    <ul class="portfolio-links">
        <li>
        <a href="<?php  echo get_permalink($parentpage->ID); ?>"><?php _e("All", "ocmx"); ?></a></li>
        <?php foreach($cat_list as $tax) :
			$link = get_term_link($tax->slug, "portfolio-category");
			$class = "";
			if($tax->term_id == $term->term_id)
				$class = "class=\"selected\"";
				echo "<li><a href=\"$link\" $class>".$tax->name."</a></li>";
			endforeach; ?>
 		</li>
    </ul>
<?php endif; ?>          

<div id="full-width">        
    <ul class="portfolio-list <?php echo $layout; ?>">
        <?php if ($portfolio->have_posts()) :
            while ($portfolio->have_posts()) :	$portfolio->the_post();
            if($i > $nextul)
                echo "\n\t</ul>\n\t<ul class=\"portfolio-list $layout\">"; $i = 1;
                    get_template_part("/functions/portfolio-list");
                $i++;
            endwhile; wp_reset_query();
            else :
                ocmx_no_posts();
            endif; ?>
    </ul>   
</div>
<?php get_footer(); ?>