<?php
global $obox_meta, $theme_options;

/* Setup Post Image Sizes */
add_image_size("post", 590, 350, true);

$theme_options = array();

$theme_options["general_site_options"] =
		array(
				array("label" => "Custom Logo", "description" => "Full URL or folder path to your custom logo.", "name" => "ocmx_custom_logo", "default" => "", "id" => "upload_button", "input_type" => "file", "args" => array("width" => 90, "height" => 75)),		
				array("label" => "Favicon", "description" => "Select a favicon for your site", "name" => "ocmx_custom_favicon", "default" => "", "id" => "upload_button_favicon", "input_type" => "file", "sub_title" => "favicon", "args" => array("width" => 16, "height" => 16)),
					array(
					"main_section" => "Custom Styling",
					"main_description" => "Set your own custom font and CSS for testimonials any any other element you wish to restyle.",
					"sub_elements" => 
						array(
				  
							array("label" => "Custom CSS", "description" => "Enter changed classes from the theme stylesheet, or custom CSS here.", "name" => "ocmx_custom_css", "default" => "", "id" => "ocmx_custom_css", "input_type" => "memo"),
				             )
				    ),
				array(
				"main_section" => "Post Meta",
				"main_description" => "These settings control which post meta is displayed on posts.",
				"sub_elements" => 
					array(
						array("label" => "Author Link", "description" => "Uncheck to hide the author link.", "name" => "ocmx_meta_author", "default" => "on", "id" => "ocmx_meta_author", "input_type" => "checkbox"),
						array("label" => "Comment Link", "name" => "ocmx_meta_comments", "Uncheck to hide the comment link posts and archives.", "default" => "on", "id" => "ocmx_meta_comments", "input_type" => "checkbox"),
						array("label" => "Date", "name" => "ocmx_meta_date", "Uncheck to hide the date on posts and archives.", "default" => "on", "id" => "ocmx_meta_date", "input_type" => "checkbox"),
						array("label" => "Social Sharing on Posts", "description" => "Uncheck to hide social sharing buttons.", "name" => "ocmx_meta_social", "default" => "on", "id" => "ocmx_meta_social", "input_type" => "checkbox"),
						array("label" => "Social Sharing on Portfolio", "description" => "Uncheck to hide social sharing buttons.", "name" => "ocmx_meta_social_port", "default" => "on", "id" => "ocmx_meta_social_port", "input_type" => "checkbox"),
						array("label" => "Tags", "description" => "Uncheck to hide tags on posts.", "name" => "ocmx_meta_tags", "default" => "on", "id" => "ocmx_meta_tags", "input_type" => "checkbox"),
						array("label" => "Video Meta", "description" => "Uncheck to hide video likes and views for oEmbed Video posts.", "name" => "ocmx_video_meta", "default" => "on", "id" => "ocmx_video_meta", "input_type" => "checkbox"),
						
					)
				),
				array("label" => "Post Count", "description" => "Number of Posts to display on the Home Page.", "name" => "ocmx_home_page_posts", "default" => "5", "id" => "", "input_type" => "select", "options" => array("1" => "1", "2" => "2", "3" => "3", "4" => "4", "5" => "5", "6" => "6", "7" => "7", "8" => "8", "9" => "9", "10" => "10", "15" => "15", "20" => "20")),
				array("label" => "Custom RSS URL", "description" => "", "name" => "ocmx_rss_url", "default" => "", "id" => "", "input_type" => "text"),
				array("label" => "Custom Footer Text", "description" => "", "name" => "ocmx_custom_footer", "default" => "Copyright 2012. Casual was created in WordPress by Obox Themes."	, "id" => "ocmx_custom_footer", "input_type" => "memo"),
				array("label" => "Site Analytics", "description" => "Enter in the Google Analytics Script here.","name" => "ocmx_googleAnalytics", "default" => "", "id" => "","input_type" => "memo"),

		array(
                   "main_section" => "Press Trends Analytics",
                   "main_description" => "Select Yes Opt out. No personal data is collected.",
                   "sub_elements" =>
                         array(
                             array("label" => "Disable Press Trends?", "description" => "PressTrends helps Obox build better themes and provide awesome support by retrieving aggregated stats. PressTrends also provides a <a href='http://wordpress.org/extend/plugins/presstrends/' title='PressTrends Plugin for WordPress' target='_blank'>plugin for you</a> that delivers stats on how your site is performing against similar sites like yours. <a href='http://www.presstrends.me' title='PressTrends' target='_blank'>Learn more…</a>","name" => "ocmx_disable_press_trends", "default" => "no", "id" => "ocmx_disable_press_trends", "input_type" => 'select', 'options' => array('Yes' => 'yes', 'No' => 'no'))
                              )
                     )
		);
$theme_options["small_ad_options"] = array(
						array(
								"label" => "Number of Small Ads", 
								"description" => "When using the select box, you must click \"Save Changes\" before the blocks are added or removed.", 
								"name" => "ocmx_small_ads", 
								"id" =>  "ocmx_small_ads",
								"prefix" => "ocmx_small_ad",
								"default" => "0", 
								"input_type" => "select", 
								"options" => array("None" => "0", "1" => "1", "2" => "2", "3" => "3", "4" => "4", "5" => "5", "6" => "6", "7" => "7", "8" => "8", "9" => "9", "10" => "10"), 
								"args" => array("width" => 125, "height" => "125")
							)
					  );
	

$theme_options["delete_gallery"] = array( 
						array(
								"label" => "Confirm", 
								"description" => "Are you sure you want to delete this gallery?", 
								"name" => "ocmx_delete_gallery_confirm", 
								"id" =>  "ocmx_delete_gallery_confirm",
								"default" => "0", 
								"input_type" => "select", 
								"options" => array("Yes" => "yes", "No" => "no")
							)
						);
/***************************************************************************/
/* Setup Defaults for this theme for optiosn which aren't set in this page */

update_option("ocmx_general_font_style_default", "Arvo, Georgia, \"Times New Roman\", Times, serif");
update_option("ocmx_navigation_font_style_default", "Arvo, Georgia, \"Times New Roman\", Times, serif");
update_option("ocmx_sub_navigation_font_style_default", "Arvo, Georgia, \"Times New Roman\", Times, serif");
update_option("ocmx_post_font_titles_style_default", "Arvo, Georgia, \"Times New Roman\", Times, serif");
update_option("ocmx_post_font_meta_style_default", "Arvo, Georgia, \"Times New Roman\", Times, serif");
update_option("ocmx_post_font_copy_font_style_default", "Arvo, Georgia, \"Times New Roman\", Times, serif");
update_option("ocmx_widget_font_titles_font_style_default", "Arvo, Georgia, \"Times New Roman\", Times, serif");
update_option("ocmx_widget_footer_titles_font_size_default", "Arvo, Georgia, \"Times New Roman\", Times, serif");

update_option("ocmx_general_font_color_default", "#3D536C");
update_option("ocmx_navigation_font_color_default", "#fff");
update_option("ocmx_sub_navigation_font_color_default", "#fff");
update_option("ocmx_post_titles_font_color_default", "#333");
update_option("ocmx_post_meta_font_color_default", "#888");
update_option("ocmx_post_copy_font_color_default", "#3D536C");
update_option("ocmx_widget_titles_font_color_default", "#333");
update_option("ocmx_widget_footer_titles_font_size_default", "#fff");

update_option("ocmx_general_font_size_default", "12");
update_option("ocmx_navigation_font_size_default", "12");
update_option("ocmx_sub_navigation_font_size_default", "12");
update_option("ocmx_post_titles_font_size_default", "20");
update_option("ocmx_post_meta_font_size_default", "12");
update_option("ocmx_post_copy_font_size_default", "12");
update_option("ocmx_widget_titles_font_size_default", "14");
update_option("ocmx_widget_footer_titles_font_size_default", "14");

update_option("allow_gallery_effect", "1");

add_action("switch_theme", "remove_ocmx_gallery_effects"); 
function remove_ocmx_gallery_effects(){delete_option("allow_gallery_effect");}; ?>