<?php $format = get_post_format();
$args  = array( 'postid' => $post->ID, 'width' => '500', 'hide_href' => false, 'imglink' => false, 'imgnocontainer' => true, 'resizer' => '500' );
$image = get_obox_media( $args );	
$link = get_permalink( $post->ID ); 
$customlink = get_post_meta( $post->ID, 'link', true );
$link_url = get_post_meta( $post->ID, 'link-url', true );
$quote_author = get_post_meta( $post->ID, 'quote-author', true );
$quote_link = get_post_meta( $post->ID, 'quote-link', true );
$quote_copy = get_post_meta( $post->ID, 'quote-copy', true );
$thumb = get_post_meta( $post->ID, 'image', true );
$video = get_post_meta( $post->ID, 'video-embed', true );
$jplayer = get_post_meta( $post->ID, 'mpthree', true ); 
$audio = get_post_meta( $post->ID, 'audio', true );
$url = get_post_meta( $post->ID, "video_link", true );
$vid_info = video_info( $url );
$views = $vid_info['views'];
$likes = $vid_info['likes']; 
?>
<div class="post-container post-<?php echo $format ?> clearfix">
	<div class="date-container">
		<a class="icon-image" href="<?php echo $link ?>"> <?php echo $format ?></a>
        <?php if( get_option( "ocmx_meta_date" ) != "false" ) : ?>
            <a class="date">
                <span class="day"><?php echo date('j', strtotime($post->post_date)); ?></span>
                <span class="month"><?php echo date('M', strtotime($post->post_date)); ?></span>
            </a>
        <?php endif; ?>
 	</div>	
    
    <?php if ( has_post_format( 'aside' )) : ?>
        <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
            <h2 class="post-title"><a href="<?php echo $link; ?>"><?php the_title(); ?></a></h2> 
            <?php if($thumb !="") : ?>
				<div class="post-image"><img src="<?php bloginfo('template_directory'); ?>/functions/timthumb.php?src=<?php echo $thumb; ?>&amp;w=520&amp;h=293&amp;zc=1&amp;q=100&amp;a=tc" alt="<?php the_title(); ?>" />	</div>
			<?php elseif($image !="") : ?>
				<div class="post-image">
					<?php echo $image; ?>
				</div>
			<?php endif; ?>
            <div class="copy">
                <?php the_content(""); ?>
            </div>
        </div>
    
    <?php elseif ( has_post_format( 'image' )) : ?>
        <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
           <?php if($thumb !="") : ?>
				<div class="post-image"><img src="<?php bloginfo('template_directory'); ?>/functions/timthumb.php?src=<?php echo $thumb; ?>&amp;w=520&amp;zc=1&amp;q=100&amp;a=tc" alt="<?php the_title(); ?>" />	</div>
			<?php elseif($image !="") : ?>
				<div class="post-image">
					<?php echo $image; ?>
				</div>
			<?php endif; ?>
            <h2 class="post-title"><a href="<?php echo $link; ?>"><?php the_title(); ?></a></h2>  
            <div class="copy">
                <?php the_excerpt(""); ?>
            </div>
        </div>
    
    <?php elseif ( has_post_format( 'link' )) : ?>		
        <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>> 
			<div class="link-post-link">
				<a href="<?php echo $customlink; ?>" target="_blank"><?php the_title(); ?></a>
			</div>
            <div class="copy">
            	<?php the_excerpt(); ?>
            </div>
        </div>
    
    <?php elseif ( has_post_format( 'quote' )) : ?>
        <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>> 
      		<div class="quote">
                <blockquote>
                	<?php if($quote_copy !="") {echo $quote_copy;} else {echo the_content("");} ?> 
                </blockquote>
                <cite><a href="<?php if($quote_link !="") {echo $quote_link;} else {echo $customlink;} ?>" title="<?php the_title(); ?>"><?php if($quote_author !="") {echo $quote_author;} else {echo the_title();} ?></a></cite>
			</div>
		</div>
    
    <?php elseif ( has_post_format( 'video' )) : ?>
        <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>> 
            <h2 class="post-title"><a href="<?php echo $link; ?>"><?php the_title(); ?></a></h2>
			<h5 class="meta">
				<!--If this is an oEmbed video and you have Video Meta checked in Theme Options, show Likes and Views -->
				<?php if ( get_option( "ocmx_video_meta" ) != "false" && $url !="" ) : ?>
					<?php if ( $views !="" ) : ?>
						<span class="views"><?php echo $views; ?></span>
  					<?php endif; 
 						  if ( $likes !="" ) : ?>
						<span class="likes"><?php echo $likes; ?></span>
					<?php endif;  
				endif; ?> 
			</h5>
			<?php if($video !="") : ?>
				<div class="post-image">
					<?php echo $video; ?>
				</div>
			<?php elseif($image !="") : ?>
				<div class="post-image">
					<?php echo $image; ?>
				</div>
			<?php endif; ?>
            <div class="copy">
                <?php the_content(""); ?>
            </div>
        </div>
    
    <?php elseif ( has_post_format( 'audio' )) : ?>	
        <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>> 
            <?php if($image !='') : ?>
                <div class="post-image">
                    <?php echo $image; ?>
                </div>
			<?php endif; ?>
		
			<?php if($jplayer !="" || $audio !="") : ?>
                <script type='text/javascript'>
                    jQuery(document).ready(function($){ 
                        jQuery("#jquery_jplayer_<?php echo $post->ID; ?>").jPlayer({
                            ready: function () {
                                $(this).jPlayer("setMedia", {
                                    <?php if( $jplayer !="") : ?>
                                        mp3 : "<?php echo $jplayer; ?>"
                                    <?php elseif ( $audio !="") : ?>
                                        mp3 : "<?php echo $audio; ?>"
                                    <?php endif; ?>
                                })
                            },
                            cssSelectorAncestor : '#audio-player-<?php echo $post->ID; ?>',
                            cssSelector : {
                                play : '.jp-play',
                                pause : '.jp-pause',
                                stop : '.jp-stop'
                            },
                            volume: 50,
                            swfPath : '<?php echo get_template_directory_uri(); ?>/scripts/',
                            solution: 'html, flash',
                            supplied : 'mp3',
                            backgroundColor : 'transparent'
                        });
                    });
                </script>
            
                <div id="jquery_jplayer_<?php echo $post->ID; ?>" class="jplayer-embed"></div> 
        
                <div id="audio-player-<?php echo $post->ID; ?>" class="audio-player">
                    <div class="play-pause">
                        <a href="#" id="jplayer_play_<?php echo $post->ID; ?>" class="jp-play clearfix" tabindex="1"><?php _e("Play", "ocmx"); ?></a>
                        <a href="#" id="jplayer_pause_<?php echo $post->ID; ?>" class="jp-pause clearfix" tabindex="1"><?php _e("Pause", "ocmx"); ?></a>
                    </div>
                    <div class="stop">
                        <a href="#" id="jplayer_stop_<?php echo $post->ID; ?>" class="jp-stop" tabindex="1"><?php _e("Stop", "ocmx"); ?></a>
                    </div>
                </div>
                
            <?php endif; ?>
            <h2 class="post-title"><a href="<?php echo $link; ?>"><?php the_title(); ?></a></h2>
            <div class="copy">
                <?php the_content(""); ?>
            </div>
        </div>
    
    <?php else : ?>
        <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
            <h2 class="post-title"><a href="<?php echo $link; ?>"><?php the_title(); ?></a></h2>
  			<h5 class="meta">
				<?php if( get_option( "ocmx_meta_author" ) != "false" ){ _e(" by "); the_author_posts_link(); } ?>
                <?php _e(" in "); the_category(", "); ?>&nbsp;
				<!--If this is an oEmbed video and you have Video Meta checked in Theme Options, show Likes and Views -->
				<?php if ( get_option( "ocmx_video_meta" ) != "false" && $url !="" ) : ?>
					<?php if ( $views !="" ) : ?>
						<span class="views"><?php echo $views; ?></span>
  					<?php endif; 
 						  if ( $likes !="" ) : ?>
						<span class="likes"><?php echo $likes; ?></span>
					<?php endif;  
				endif; ?> 
			</h5>
            <?php if($image !='') : ?>
                <div class="post-image">
                    <?php echo $image; ?>
                </div>
			<?php endif; ?>
            <div class="copy">
                <?php the_content(""); ?>
            </div>
        </div>
    <?php endif; ?>

</div>