<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 4.3.2 or newer
 *
 * @package		CodeIgniter
 * @author		ExpressionEngine Dev Team
 * @copyright	Copyright (c) 2008 - 2009, EllisLab, Inc.
 * @license		http://codeigniter.com/user_guide/license.html
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
// ------------------------------------------------------------------------

/**
 * CodeIgniter Reprice Helpers
 *
 * @package		CodeIgniter
 * @subpackage	Helpers
 * @category	Helpers
 * @author		ExpressionEngine Dev Team
 * @link		http://codeigniter.com/user_guide/helpers/reprice_helper.html
 */
if (!function_exists('validateNumber')) {

    function validateNumber($cell_no) {
        $is_valid = false;
        if ($cell_no[0] == 0) {
            $new_number = substr($cell_no, 1, strlen($cell_no));
            $new_number = "92" . $new_number;
            $is_valid = true;
        } elseif ($cell_no[0] == 9 && $cell_no[1] == 2) {
            $new_number = $cell_no;
            $is_valid = true;
        } elseif ($cell_no[0] == 3) {
            $new_number = "92" . $cell_no;
            $is_valid = true;
        }
        if ($is_valid) {
            return $new_number;
        } else {
            return false;
        }
    }

}
if (!function_exists('sendSMS')) {

    function sendSMS($id, $myNo, $mask, $dest, $msg, $pwd) {
        $params = array(
            'Src_nbr' => $myNo,
            'Password' => $pwd,
            'Dst_nbr' => $dest,
            'Mask' => $mask,
            'Message' => $msg,
            'TransactionID' => $id
        );

        //hiding fatal error exception
        try {
            $client = new SoapClient('http://203.82.55.30/CSWS/Service.asmx?wsdl');

            $info = $client->__soapCall("SendSMS", array($params));
//            echo '<pre>';
//            print_r($info);
//            exit;
            $result = 'SMS has been sent.';
//            $result = $info->SendSMSResult->string[1];
            return $result;
        } catch (Exception $e) {
            //print_r($e);
        }
    }

}
if (!function_exists('sendSkyaimsSMS')) {

    function sendSkyaimsSMS($to, $msg) {

        $id = time();
        $myNo = '923154002696';
        $pwd = smspassword();


        $mask = '';
        $sendsms = sendSMS($id, $myNo, $mask, $to, $msg, $pwd);

        if ($sendsms == 'SMS has been sent.') {

            return true;
        } else {

            return false;
        }
    }

}
if (!function_exists('sendSMSnewDistributor')) {

    function sendSMSnewDistributor($id) {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $new_dist_result = $CI->Customer->getUserByCode($id);
        if (count($new_dist_result) > 0) {

            $cell_no = validateNumber($new_dist_result[0]["mobile_no"]);
//        echo $cell_no;
//        exit;
            if ($cell_no) {

                $to = $cell_no;
                $msg = "CONGRATS!";
//                $msg .= "\nWELCOME TO Fly Up";
                if ($new_dist_result[0]["gender"] == 0)
                    $msg .= "\nMISS: " . $new_dist_result[0]["name"] . ".";
                else
                    $msg .= "\nMR: " . $new_dist_result[0]["name"] . ".";
                $msg .= "\nON BECOMING ON FLY UP DISTRIBUTOR.";
                $msg .= "\nAS " . ($new_dist_result[0]["type"] == 1 ? "ODD MEMBER." : "EVEN MEMBER.");
                $msg .= "\nPLEASE NOTE DOWN YOUR DETAIL'S AND KEEP THEM SECURE.";
                $msg .= "\nYOUR CODE: " . $new_dist_result[0]["user_code"];
                $msg .= "\nYOUR PSWD: " . $new_dist_result[0]["password"];
                $msg .= "\nYOUR PIN: " . $new_dist_result[0]["pin"];
//                $msg .= "\nSECURE YOUR PSWDS";
                $msg .= "\nYOUR WELL WISHER,";
                $msg .= "\nwww.flyupint.com";

                $temp = sendSkyaimsSMS($to, $msg);
                $introducer_log = array(
                    "receiver_no" => $cell_no,
                    "message" => $msg,
                    "date" => date("y-m-d")
                );
                if (!$temp) {
                    $introducer_log["status"] = 1;
                }
                $CI->Customer->insertSMS($introducer_log);
            }
        }
    }

}
if (!function_exists('sendSMSToIntroducer')) {

    function sendSMSToIntroducer($intro_name, $intro_cell_no, $distributorName) {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $cell_no = validateNumber($intro_cell_no);
        if ($cell_no) {
            $to = $cell_no;
            $msg = "CONGRATS!";
            $msg .= "\nMR/MS: " . $intro_name;
            $msg .= "\nYOU HAVE INTRODUCED";
            $msg .= "\nMR/MS: " . $distributorName;
            $msg .= "\nWELL WISHER";
            $msg .= "\nwww.flyupint.com";

            $introducer_log = array(
                "receiver_no" => $cell_no,
                "message" => $msg,
                "date" => date("y-m-d")
            );
            if (!sendSkyaimsSMS($to, $msg)) {
                $introducer_log["status"] = 1;
            }
            $CI->Customer->insertSMS($introducer_log);
        }
    }

}
if (!function_exists('getBonusEarning')) {

    function getBonusEarning($user_code) {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $CI->db->where('user_id', $user_code);
        $CI->db->where('(balance_type = "bonus")');
        $CI->db->select_sum('dabit');
        $dabit = $CI->db->get('payment_log')->result_array();
        $direct = $dabit[0]["dabit"];
        return $direct;
    }

}
if (!function_exists('getDirectEarning')) {

    function getDirectEarning($user_code) {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $CI->db->where('user_id', $user_code);
        $CI->db->where('(balance_type = "direct")');
        $CI->db->where(array('type' => 3));
        $CI->db->select_sum('dabit');
        $dabit = $CI->db->get('payment_log')->result_array();
        $direct = $dabit[0]["dabit"];
        return $direct;
    }

}
if (!function_exists('getFlyUpEarning')) {

    function getFlyUpEarning($user_code) {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $CI->db->where('user_id', $user_code);
        $CI->db->where('(balance_type = "flyUp")');
        $CI->db->select_sum('dabit');
        $dabit = $CI->db->get('payment_log')->result_array();
        $flyUp = $dabit[0]["dabit"];
        return $flyUp;
    }

}
if (!function_exists('generateRandomString')) {

    function generateRandomString($length = 6) {

        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $randomString;
    }

}




if (!function_exists('getUserFlyUpEarnings')) {

    function getUserFlyUpEarnings($user_code, $filter_radio = "", $month = "", $startDate = "", $endDate = "") {
        $CI = get_instance();
//        $CI->load->model('customer_model', 'Customer');
//        $CI->load->model('admin_model', 'Admin');
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {
            $CI->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $CI->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $CI->db->where('(DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '")');
        }
        if ($user_code != "") {
            $CI->db->where('user_id', $user_code);
        }

        $CI->db->where(array('type' => 1));
        $CI->db->select_sum('dabit');
        $kk = $CI->db->get('payment_log')->result_array();
//        echo $CI->db->last_query();
        $flyUp = $kk[0]['dabit'];
        if ($flyUp == "") {
            $flyUp = 0;
        }
        return $flyUp;
//        return $data;
    }

}
if (!function_exists('getUserDirectEarnings')) {

    function getUserDirectEarnings($user_code, $filter_radio = "", $month = "", $startDate = "", $endDate = "") {
        $CI = get_instance();
//        $CI->load->model('customer_model', 'Customer');
//        $CI->load->model('admin_model', 'Admin');
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {
            $CI->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $CI->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $CI->db->where('(DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '")');
        }
        if ($user_code != "") {
            $CI->db->where('user_id', $user_code);
        }

        $CI->db->where(array('type' => 3));
        $CI->db->where('(balance_type = "direct")');
        $CI->db->select_sum('dabit');
        $kk = $CI->db->get('payment_log')->result_array();
//        echo $CI->db->last_query();
        $direct = $kk[0]['dabit'];
        if ($direct == "") {
            $direct = 0;
        }
        return $direct;
//        return $data;
    }

}
if (!function_exists('renewalPaymentForFlyUp')) {

    function renewalPaymentForFlyUp($id) {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $payment_data = $CI->Customer->getPaymentLogByUserid($id);
        $index = 0;

        if (count($payment_data) > 0) {
            $index = count($payment_data);
            $payment_log = array(
                'user_id' => $CI->flyUpId,
                'balance_type' => $CI->balance_type[2],
                'dabit' => $CI->renewal_profit,
                'amount' => $payment_data[$index - 1]['amount'] + $CI->renewal_profit,
                'date' => date('Y-m-d H:i:s'),
                'benifit_from' => $CI->session->userdata("renewal_benefit_from"),
                'type' => 1,
            );
            $CI->Customer->createPaymentLog($payment_log);
        } else {

            $payment_log = array(
                'user_id' => $CI->flyUpId,
                'balance_type' => $CI->balance_type[2],
                'dabit' => $CI->renewal_profit,
                'amount' => $CI->renewal_profit,
                'date' => date('Y-m-d H:i:s'),
                'benifit_from' => $CI->session->userdata("renewal_benefit_from"),
                'type' => 1,
            );
            $CI->Customer->createPaymentLog($payment_log);
        }
        return;
    }

}
if (!function_exists('renewalProcess')) {

    function renewalProcess($parent_code, $child_type) {
        $CI = get_instance();
//        echo  $CI->renewal_profit."  s";
//        exit;
        $CI->load->model('customer_model', 'Customer');
        $check_tree_level = $CI->Customer->getTreeLevel();
        $level_of_tree = count($check_tree_level);
        $user_id = $parent_code;
        $login_user_info = $CI->Customer->getUserByCode($user_id);
        if (!empty($login_user_info)) {
            $get_parent = $CI->Customer->getParentByUserId($login_user_info[0]['parent_id']);
            if (!empty($get_parent)) {
                if ($child_type == 1) {

//odd child RENEWAL 
                    $data = array(
                        'total_balance' => $login_user_info[0]['total_balance'] + $CI->renewal_profit,
                        'remaning_blance' => $login_user_info[0]['remaning_blance'] + $CI->renewal_profit,
                        'odd_side_profit' => $login_user_info[0]['odd_side_profit'] + $CI->renewal_profit,
                    );
                    $CI->Customer->updateParentById($user_id, $data);
                    $audit_log = array(
                        'reason_type' => 1, // odd child reason 
                        'user_id' => $login_user_info[0]['user_code'],
                        'created_id' => $CI->session->userdata("renewal_benefit_from"),
                        'detail' => $CI->reason_type[0],
                        'profit' => $CI->take_profit['yes'],
                        'date' => date('Y-m-d H:i:s'),
                    );
                    $CI->Customer->createAuditLog($audit_log);
                    $payment_data = $CI->Customer->getPaymentLogByUserid($user_id);
                    if (count($payment_data) > 0) {
                        $index = count($payment_data);
                        $payment_log = array(
                            'user_id' => $login_user_info[0]['user_code'],
                            'balance_type' => $CI->balance_type[3],
                            'dabit' => $CI->renewal_profit,
                            'amount' => $payment_data[$index - 1]['amount'] + $CI->renewal_profit,
                            'date' => date('Y-m-d H:i:s'),
                            'benifit_from' => $CI->session->userdata("renewal_benefit_from"),
                            'type' => 3,
                        );
                    } else {
                        $payment_log = array(
                            'user_id' => $login_user_info[0]['user_code'],
                            'balance_type' => $CI->balance_type[3],
                            'dabit' => renewal_benefit_from,
                            'amount' => renewal_benefit_from,
                            'date' => date('Y-m-d H:i:s'),
                            'benifit_from' => $CI->session->userdata("renewal_benefit_from"),
                            'type' => 3,
                        );
                    }
                    $CI->Customer->createPaymentLog($payment_log);
                    bonus($login_user_info[0]['parent_id'], 'renewal');
//                    return;
                    if ($CI->session->userdata("admin_code")) {
//                        redirect('admin/registerUser/success');
                    } else {
                        redirect('customer/renewal/success');
                    }
                } else {
//even child RENEWAL here
//                    $string_result = date('m', strtotime(date("2014-02-01"))); // current month

                    if ($login_user_info[0]['at_level'] == 0) {
// admin in zero level if admin RENEWAL 
                        $audit_log = array(
                            'reason_type' => 2, // even child reason 
                            'user_id' => $login_user_info[0]['user_code'],
                            'created_id' => $CI->session->userdata("renewal_benefit_from"),
                            'detail' => $CI->reason_type[1],
                            'profit' => $CI->take_profit['no'],
                            'date' => date('Y-m-d H:i:s'),
                        );
                        $CI->Customer->createAuditLog($audit_log);
                        $fly_up_info = $CI->Customer->getFlyUpById($CI->flyUpId);
                        if (count($fly_up_info) > 0) {
                            $add_profit = array(
                                'total_balance' => $fly_up_info[0]['total_balance'] + $CI->renewal_profit,
                                'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $CI->renewal_profit,
                            );
                            $CI->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                            $audit_log = array(
                                'user_id' => $CI->flyUpId,
                                'created_id' => $CI->session->userdata("renewal_benefit_from"),
                                'profit' => $CI->take_profit['yes'],
                                'date' => date('Y-m-d H:i:s'),
                            );
                            $CI->Customer->createAuditLog($audit_log);
                            renewalPaymentForFlyUp($CI->flyUpId);
                        }
                        bonus($CI->flyUpId, 'renewal');
                        if ($CI->session->userdata("admin_code")) {
                            redirect('admin/registerUser/success');
                        } else {
                            redirect('customer/renewal/success');
                        }
                    } else {
                        $audit_log = array(
                            'reason_type' => 2, // even child  reason 
                            'user_id' => $login_user_info[0]['user_code'],
                            'created_id' => $CI->session->userdata("renewal_benefit_from"),
                            'detail' => $CI->reason_type[1],
                            'profit' => $CI->take_profit['no'],
                            'date' => date('Y-m-d H:i:s'),
                        );
                        $CI->Customer->createAuditLog($audit_log);
                        for ($i = 1; $i <= $level_of_tree; $i++) {
                            if ($get_parent[0]['user_code'] == $CI->flyUpId) {
                                $fly_up_info = $CI->Customer->getFlyUpById($CI->flyUpId);
                                $add_profit = array(
                                    'total_balance' => $fly_up_info[0]['total_balance'] + $CI->renewal_profit,
                                    'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $CI->renewal_profit,
                                );
                                $CI->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                                $audit_log = array(
                                    'user_id' => $CI->flyUpId,
                                    'created_id' => $CI->session->userdata("renewal_benefit_from"),
                                    'profit' => $CI->take_profit['yes'],
                                    'date' => date('Y-m-d H:i:s'),
                                );
                                $CI->Customer->createAuditLog($audit_log);
                                renewalPaymentForFlyUp($CI->flyUpId);
                                bonus($CI->flyUpId, 'renewal');
                                if ($CI->session->userdata("admin_code")) {
                                    redirect('admin/registerUser/success');
                                } else {
                                    redirect('customer/renewal/success');
                                }
                            }
                            $join_date = date("Y-m-d", strtotime($get_parent[0]['join_date']));
                            $current_date = date("Y-m-d");
                            $timeDiff = strtotime($current_date) - strtotime($join_date);
                            $numberDays = $timeDiff / 86400;  //
                            $count = 0;
                            while ($numberDays >= 30) {
                                $numberDays = $numberDays - 30;
                                $count++;
                            }
                            $depth_level = $get_parent[0]['depth_level'];
                            if ($count % 2 != 0) {
                                // even month
                                if ($login_user_info[0]['type'] != 2) {
                                    $audit_log = array(
                                        'reason_type' => 5, // even month master child odd reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("renewal_benefit_from"),
                                        'detail' => $CI->reason_type[4],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    $CI->Customer->createAuditLog($audit_log);
                                } elseif ((((($login_user_info[0]['at_level'] + 1) - $get_parent[0]['at_level']) > $depth_level)) && $get_parent[0]['category'] == 0) {
                                    $audit_log = array(
                                        'reason_type' => 4, // depth level reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("renewal_benefit_from"),
                                        'detail' => $CI->reason_type[3],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    $CI->Customer->createAuditLog($audit_log);
                                    $data_info = array(
                                        'lost_blance' => $get_parent[0]['lost_blance'] + $CI->renewal_profit,
                                    );
                                    $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                } elseif ($get_parent[0]['is_expire'] == 1) {
                                    $audit_log = array(
                                        'reason_type' => 3, // expire reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("renewal_benefit_from"),
                                        'detail' => $CI->reason_type[2],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    $CI->Customer->createAuditLog($audit_log);
                                }
                                if ($login_user_info[0]['type'] == 2 && ((((($login_user_info[0]['at_level'] + 1) - $get_parent[0]['at_level']) <= $depth_level)) || $get_parent[0]['category'] == 1) && $get_parent[0]['is_expire'] == 0) {
                                    if ($get_parent[0]['is_expire'] == 0) {
                                        $data_info = array(
                                            'total_balance' => $get_parent[0]['total_balance'] + $CI->renewal_profit,
                                            'remaning_blance' => $get_parent[0]['remaning_blance'] + $CI->renewal_profit,
                                            'even_side_profit' => $get_parent[0]['even_side_profit'] + $CI->renewal_profit,
                                        );
                                        $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                        $audit_log = array(
                                            'reason_type' => 8,
                                            'user_id' => $get_parent[0]['user_code'],
                                            'created_id' => $CI->session->userdata("renewal_benefit_from"),
                                            'detail' => $CI->reason_type[8],
                                            'profit' => $CI->take_profit['yes'],
                                            'date' => date('Y-m-d H:i:s'),
                                        );
                                        $CI->Customer->createAuditLog($audit_log);
                                        $payment_data = $CI->Customer->getPaymentLogByUserid($get_parent[0]['user_code']);
                                        if (count($payment_data) > 0) {
                                            $index = count($payment_data);
                                            $payment_log = array(
                                                'user_id' => $get_parent[0]['user_code'],
                                                'balance_type' => $CI->balance_type[2],
                                                'dabit' => $CI->renewal_profit,
                                                'amount' => $payment_data[$index - 1]['amount'] + $CI->renewal_profit,
                                                'date' => date('Y-m-d H:i:s'),
                                                'benifit_from' => $CI->session->userdata("renewal_benefit_from"),
                                                'type' => 1,
                                            );
                                            $CI->Customer->createPaymentLog($payment_log);
                                        } else {
                                            $payment_log = array(
                                                'user_id' => $get_parent[0]['user_code'],
                                                'balance_type' => $CI->balance_type[2],
                                                'dabit' => $CI->renewal_profit,
                                                'amount' => $CI->renewal_profit,
                                                'date' => date('Y-m-d H:i:s'),
                                                'benifit_from' => $CI->session->userdata("renewal_benefit_from"),
                                                'type' => 1,
                                            );
                                            $CI->Customer->createPaymentLog($payment_log);
                                        }
                                        bonus($get_parent[0]['parent_id'], 'renewal');
                                        if ($CI->session->userdata("admin_code")) {
                                            redirect('admin/registerUser/success');
                                        } else {
                                            redirect('customer/renewal/success');
                                        }
                                    } else {
                                        $data_info = array(
                                            'lost_blance' => $get_parent[0]['lost_blance'] + $CI->renewal_profit,
                                        );
                                        $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                    }
                                } else {
                                    if ($i == $level_of_tree) {
                                        $fly_up_info = $CI->Customer->getFlyUpById($CI->flyUpId);
                                        $add_profit = array(
                                            'total_balance' => $fly_up_info[0]['total_balance'] + $CI->renewal_profit,
                                            'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $CI->renewal_profit,
                                        );
                                        $CI->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                                        $audit_log = array(
//                                            'reason_type' => 4, // depth level reason 
                                            'user_id' => $CI->flyUpId,
                                            'created_id' => $CI->session->userdata("renewal_benefit_from"),
//                                            'detail' => $CI->reason_type[3],
                                            'profit' => $CI->take_profit['yes'],
                                            'date' => date('Y-m-d H:i:s'),
                                        );
                                        $CI->Customer->createAuditLog($audit_log);
                                        renewalPaymentForFlyUp($CI->flyUpId);
                                        bonus($CI->flyUpId, 'renewal');
                                        if ($CI->session->userdata("admin_code")) {
                                            redirect('admin/registerUser/success');
                                        } else {
                                            redirect('customer/renewal/success');
                                        }
                                    }
                                }
                            } else {
                                // odd month
                                if ($login_user_info[0]['type'] != 1) {
                                    $audit_log = array(
                                        'reason_type' => 6, // odd month master child even reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("renewal_benefit_from"),
                                        'detail' => $CI->reason_type[5],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    $CI->Customer->createAuditLog($audit_log);
                                } elseif ((((($login_user_info[0]['at_level'] + 1) - $get_parent[0]['at_level']) > $depth_level)) && $get_parent[0]['category'] == 0) {
                                    $audit_log = array(
                                        'reason_type' => 4, // depth level reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("renewal_benefit_from"),
                                        'detail' => $CI->reason_type[3],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    $CI->Customer->createAuditLog($audit_log);
                                    $data_info = array(
                                        'lost_blance' => $get_parent[0]['lost_blance'] + $CI->renewal_profit,
                                    );
                                    $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                } elseif ($get_parent[0]['is_expire'] == 1) {
                                    $audit_log = array(
                                        'reason_type' => 3, // expire reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("renewal_benefit_from"),
                                        'detail' => $CI->reason_type[2],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    $CI->Customer->createAuditLog($audit_log);
                                }
                                if ($login_user_info[0]['type'] == 1 && ((((($login_user_info[0]['at_level'] + 1) - $get_parent[0]['at_level']) <= $depth_level)) || $get_parent[0]['category'] == 1) && $get_parent[0]['is_expire'] == 0) {
                                    if ($get_parent[0]['is_expire'] == 0) {
                                        $data_info = array(
                                            'total_balance' => $get_parent[0]['total_balance'] + $CI->renewal_profit,
                                            'remaning_blance' => $get_parent[0]['remaning_blance'] + $CI->renewal_profit,
                                            'even_side_profit' => $get_parent[0]['even_side_profit'] + $CI->renewal_profit,
                                        );
                                        $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                        $audit_log = array(
                                            'reason_type' => 7,
                                            'user_id' => $get_parent[0]['user_code'],
                                            'created_id' => $CI->session->userdata("renewal_benefit_from"),
                                            'detail' => $CI->reason_type[7],
                                            'profit' => $CI->take_profit['yes'],
                                            'date' => date('Y-m-d H:i:s'),
                                        );
                                        $CI->Customer->createAuditLog($audit_log);
                                        $payment_data = $CI->Customer->getPaymentLogByUserid($get_parent[0]['user_code']);
                                        if (count($payment_data) > 0) {
                                            $index = count($payment_data);
                                            $payment_log = array(
                                                'user_id' => $get_parent[0]['user_code'],
                                                'balance_type' => $CI->balance_type[2],
                                                'dabit' => $CI->renewal_profit,
                                                'amount' => $payment_data[$index - 1]['amount'] + $CI->renewal_profit,
                                                'date' => date('Y-m-d H:i:s'),
                                                'benifit_from' => $CI->session->userdata("renewal_benefit_from"),
                                                'type' => 1,
                                            );
                                            $CI->Customer->createPaymentLog($payment_log);
                                        } else {
                                            $payment_log = array(
                                                'user_id' => $get_parent[0]['user_code'],
                                                'balance_type' => $CI->balance_type[2],
                                                'dabit' => $CI->renewal_profit,
                                                'amount' => $CI->renewal_profit,
                                                'date' => date('Y-m-d H:i:s'),
                                                'benifit_from' => $CI->session->userdata("renewal_benefit_from"),
                                                'type' => 1,
                                            );
                                            $CI->Customer->createPaymentLog($payment_log);
                                        }
                                        bonus($get_parent[0]['parent_id'], 'renewal');
                                        if ($CI->session->userdata("admin_code")) {
                                            redirect('admin/registerUser/success');
                                        } else {

                                            redirect('customer/renewal/success');
                                        }
                                    } else {
                                        $data_info = array(
                                            'lost_blance' => $get_parent[0]['lost_blance'] + $CI->profit,
                                        );
                                        $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                    }
                                } else {
                                    if ($i == $level_of_tree) {
                                        $fly_up_info = $CI->Customer->getFlyUpById($CI->flyUpId);
                                        $add_profit = array(
                                            'total_balance' => $fly_up_info[0]['total_balance'] + $CI->profit,
                                            'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $CI->profit
                                        );
                                        $CI->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                                        $audit_log = array(
                                            'user_id' => $CI->flyUpId,
                                            'created_id' => $CI->session->userdata("benifit_from_id"),
                                            'profit' => $CI->take_profit['yes'],
                                            'date' => date('Y-m-d H:i:s'),
                                        );
                                        $CI->Customer->createAuditLog($audit_log);
                                        renewalPaymentForFlyUp($CI->flyUpId);
                                        bonus($CI->flyUpId, 'renewal');
                                        if ($CI->session->userdata("admin_code")) {
                                            redirect('admin/registerUser/success');
                                        } else {
                                            redirect('customer/renewal/success');
                                        }
                                    }
                                }
                            }
                            $login_user_info[0]['type'] = $get_parent[0]['type'];
                            $get_parent = $CI->Customer->getParentByUserId($get_parent[0]['parent_id']);
                        }
                    }
                }
            }
        }
    }

}






if (!function_exists('checkUserHaveChiledCurrentMoth')) {

    function checkUserHaveChiledCurrentMoth($parent_id) {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $have = $CI->Customer->checkUserHaveChiledCurrentMoth($parent_id);
        return $have;
    }

}
if (!function_exists('bonus')) {

    function bonus($parent_id, $temp = "") {
        $index = 0;

        $CI = get_instance();
        if ($temp == "renewal") {
            $CI->session->set_userdata("benifit_from_id", $CI->session->userdata("renewal_benefit_from"));
        }
        $CI->load->model('customer_model', 'Customer');
        $check_tree_level = $CI->Customer->getTreeLevel();
        $level_of_tree = count($check_tree_level);
        $get_grand_parent = $CI->Customer->getParentByUserId($parent_id);
        $haveChildCurrentMonth = $CI->Customer->checkUserHaveChiledCurrentMoth($get_grand_parent[0]['user_code']);
        for ($i = 1; $i <= $level_of_tree; $i++) {
            if ($get_grand_parent[0]['user_code'] == $CI->flyUpId) {

                $fly_up_info = $CI->Customer->getFlyUpById($CI->flyUpId);
                $add_profit = array(
                    'total_balance' => $fly_up_info[0]['total_balance'] + $CI->bonus,
                    'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $CI->bonus,
                );
                $CI->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                $audit_log = array(
                    'user_id' => $CI->flyUpId,
                    'created_id' => $CI->session->userdata("benifit_from_id"),
                    'profit' => $CI->take_profit['yes'],
                    'date' => date('Y-m-d H:i:s'),
                );
                $CI->Customer->createBonusAuditLog($audit_log);
                $payment_data = $CI->Customer->getPaymentLogByUserid($CI->flyUpId);
                if (count($payment_data) > 0) {
                    $index = count($payment_data);
                    $payment_log = array(
                        'user_id' => $CI->flyUpId,
                        'balance_type' => $CI->balance_type[7],
                        'dabit' => $CI->bonus,
                        'amount' => $payment_data[$index - 1]['amount'] + $CI->bonus,
                        'date' => date('Y-m-d H:i:s'),
                        'benifit_from' => $CI->session->userdata("benifit_from_id"),
                        'type' => 24,
                    );
                } else {
                    $payment_log = array(
                        'user_id' => $CI->flyUpId,
                        'balance_type' => $CI->balance_type[7],
                        'dabit' => $CI->bonus,
                        'amount' => $CI->bonus,
                        'date' => date('Y-m-d H:i:s'),
                        'benifit_from' => $CI->session->userdata("benifit_from_id"),
                        'type' => 24,
                    );
                }
                $CI->Customer->createPaymentLog($payment_log);
                return;
            }
            if ($get_grand_parent[0]['depth_level'] >= 6 && count($haveChildCurrentMonth) > 0) {

                $data = array(
                    'total_balance' => $get_grand_parent[0]['total_balance'] + $CI->bonus,
                    'remaning_blance' => $get_grand_parent[0]['remaning_blance'] + $CI->bonus,
                );

                $CI->Customer->updateParentById($get_grand_parent[0]['user_code'], $data);
                $audit_log = array(
                    'reason_type' => 10, // odd child reason 
                    'user_id' => $get_grand_parent[0]['user_code'],
                    'created_id' => $CI->session->userdata("benifit_from_id"),
                    'detail' => $CI->reason_type[9],
                    'profit' => $CI->take_profit['yes'],
                    'date' => date('Y-m-d H:i:s'),
                );
                $CI->Customer->createBonusAuditLog($audit_log);
                $payment_data = $CI->Customer->getPaymentLogByUserid($get_grand_parent[0]['user_code']);
                if (count($payment_data) > 0) {
                    $index = count($payment_data);
                    $payment_log = array(
                        'user_id' => $get_grand_parent[0]['user_code'],
                        'balance_type' => $CI->balance_type[7],
                        'dabit' => $CI->bonus,
                        'amount' => $payment_data[$index - 1]['amount'] + $CI->bonus,
                        'date' => date('Y-m-d H:i:s'),
                        'benifit_from' => $CI->session->userdata("benifit_from_id"),
                        'type' => 24,
                    );
                } else {
                    $payment_log = array(
                        'user_id' => $get_grand_parent[0]['user_code'],
                        'balance_type' => $CI->balance_type[7],
                        'dabit' => $CI->bonus,
                        'amount' => $CI->bonus,
                        'date' => date('Y-m-d H:i:s'),
                        'benifit_from' => $CI->session->userdata("benifit_from_id"),
                        'type' => 24,
                    );
                }
                $CI->Customer->createPaymentLog($payment_log);
                return;
            } else {
                $audit_log = array(
                    'reason_type' => 10, // even child reason 
                    'user_id' => $get_grand_parent[0]['user_code'],
                    'created_id' => $CI->session->userdata("benifit_from_id"),
                    'detail' => $CI->reason_type[9],
                    'profit' => $CI->take_profit['no'],
                    'date' => date('Y-m-d H:i:s'),
                );
                $CI->Customer->createBonusAuditLog($audit_log);
                $get_grand_parent = $CI->Customer->getParentByUserId($get_grand_parent[0]['parent_id']);
                $haveChildCurrentMonth = $CI->Customer->checkUserHaveChiledCurrentMoth($get_grand_parent[0]['user_code']);
            }
            if ($i == $level_of_tree) {

                $fly_up_info = $CI->Customer->getFlyUpById($CI->flyUpId);
                $add_profit = array(
                    'total_balance' => $fly_up_info[0]['total_balance'] + $CI->bonus,
                    'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $CI->bonus,
                );
                $CI->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                $audit_log = array(
                    'user_id' => $CI->flyUpId,
                    'created_id' => $CI->session->userdata("benifit_from_id"),
                    'profit' => $CI->take_profit['yes'],
                    'date' => date('Y-m-d H:i:s'),
                );
                $CI->Customer->createBonusAuditLog($audit_log);
                return;
            }
        }
    }

}
if (!function_exists('createChild')) {

    function createChild($intrID) {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $check_tree_level = $CI->Customer->getTreeLevel();
        $level_of_tree = count($check_tree_level);
        $user_id = $intrID;

        $login_user_info = $CI->Customer->getUserByCode($user_id);
        if (!empty($login_user_info)) {
            $get_parent = $CI->Customer->getParentByUserId($login_user_info[0]['parent_id']);
            if (!empty($get_parent)) {
                $odd_or_even = $login_user_info[0]['odd_childs'] + $login_user_info[0]['even_childs'];
                $category = 0;
                if ($odd_or_even >= 1) {
                    $category = 1;
                }
                if ($odd_or_even % 2 == 0) {

//odd child create here 
                    $data = array(
                        'total_balance' => $login_user_info[0]['total_balance'] + $CI->profit,
                        'remaning_blance' => $login_user_info[0]['remaning_blance'] + $CI->profit,
                        'odd_side_profit' => $login_user_info[0]['odd_side_profit'] + $CI->profit,
                        'odd_childs' => $login_user_info[0]['odd_childs'] + 1,
                        'category' => $category,
                        'depth_level' => $login_user_info[0]['depth_level'] + 1,
                    );
                    $CI->Customer->updateParentById($user_id, $data);
                    $audit_log = array(
                        'reason_type' => 1, // odd child reason 
                        'user_id' => $login_user_info[0]['user_code'],
                        'created_id' => $CI->session->userdata("benifit_from_id"),
                        'detail' => $CI->reason_type[0],
                        'profit' => $CI->take_profit['yes'],
                        'date' => date('Y-m-d H:i:s'),
                    );
                    $CI->Customer->createAuditLog($audit_log);
                    $payment_data = $CI->Customer->getPaymentLogByUserid($user_id);
                    if (count($payment_data) > 0) {
                        $index = count($payment_data);
                        $payment_log = array(
                            'user_id' => $login_user_info[0]['user_code'],
                            'balance_type' => $CI->balance_type[1],
                            'dabit' => $CI->profit,
                            'amount' => $payment_data[$index - 1]['amount'] + $CI->profit,
                            'date' => date('Y-m-d H:i:s'),
                            'benifit_from' => $CI->session->userdata("benifit_from_id"),
                            'type' => 3,
                        );
                    } else {
                        $payment_log = array(
                            'user_id' => $login_user_info[0]['user_code'],
                            'balance_type' => $CI->balance_type[1],
                            'dabit' => $CI->profit,
                            'amount' => $CI->profit,
                            'date' => date('Y-m-d H:i:s'),
                            'benifit_from' => $CI->session->userdata("benifit_from_id"),
                            'type' => 3,
                        );
                    }
                    $CI->Customer->createPaymentLog($payment_log);
                    bonus($login_user_info[0]['parent_id']);
                    if ($CI->session->userdata("admin_code")) {
                        redirect('admin/registerUser/success');
                    } else {
                        redirect('customer/registerUser/success');
                    }
//                    return;
                } else {
//even child create here
//                    $string_result = date('m', strtotime(date("2014-02-01"))); // current month

                    if ($login_user_info[0]['at_level'] == 0) {
// admin in zero level if admin create child 


                        $audit_log = array(
                            'reason_type' => 2, // even child reason 
                            'user_id' => $login_user_info[0]['user_code'],
                            'created_id' => $CI->session->userdata("benifit_from_id"),
                            'detail' => $CI->reason_type[1],
                            'profit' => $CI->take_profit['no'],
                            'date' => date('Y-m-d H:i:s'),
                        );
                        $CI->Customer->createAuditLog($audit_log);

                        $fly_up_info = $CI->Customer->getFlyUpById($CI->flyUpId);
                        if (count($fly_up_info) > 0) {
                            $add_profit = array(
                                'total_balance' => $fly_up_info[0]['total_balance'] + $CI->profit,
                                'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $CI->profit,
                            );
                            $parent_update = array(
                                'even_childs' => $login_user_info[0]['even_childs'] + 1,
                                'depth_level' => $login_user_info[0]['depth_level'] + 1,
                                'category' => $category,
                            );
                            $CI->Customer->updateParentById($user_id, $parent_update);
                            $CI->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                            $audit_log = array(
                                'user_id' => $CI->flyUpId,
                                'created_id' => $CI->session->userdata("benifit_from_id"),
                                'profit' => $CI->take_profit['yes'],
                                'date' => date('Y-m-d H:i:s'),
                            );
                            $CI->Customer->createAuditLog($audit_log);
                            paymentTransaction($CI->flyUpId);
                        }
                        bonus($CI->flyUpId);
                        if ($CI->session->userdata("admin_code")) {
                            redirect('admin/registerUser/success');
                        } else {
                            redirect('customer/registerUser/success');
                        }
//                        return;
                    } else {

                        $audit_log = array(
                            'reason_type' => 2, // even child  reason 
                            'user_id' => $login_user_info[0]['user_code'],
                            'created_id' => $CI->session->userdata("benifit_from_id"),
                            'detail' => $CI->reason_type[1],
                            'profit' => $CI->take_profit['no'],
                            'date' => date('Y-m-d H:i:s'),
                        );
                        $CI->Customer->createAuditLog($audit_log);
                        for ($i = 1; $i <= $level_of_tree; $i++) {
                            if ($get_parent[0]['user_code'] == $CI->flyUpId) {

                                $fly_up_info = $CI->Customer->getFlyUpById($CI->flyUpId);
                                $add_profit = array(
                                    'total_balance' => $fly_up_info[0]['total_balance'] + $CI->profit,
                                    'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $CI->profit,
                                );
                                $CI->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                                $audit_log = array(
                                    'user_id' => $CI->flyUpId,
                                    'created_id' => $CI->session->userdata("benifit_from_id"),
                                    'profit' => $CI->take_profit['yes'],
                                    'date' => date('Y-m-d H:i:s'),
                                );
                                $CI->Customer->createAuditLog($audit_log);
                                $parent_update = array(
                                    'even_childs' => $login_user_info[0]['even_childs'] + 1,
                                    'depth_level' => $login_user_info[0]['depth_level'] + 1,
                                    'category' => $category
                                );
                                $CI->Customer->updateParentById($user_id, $parent_update);
                                paymentTransaction($CI->flyUpId);
                                bonus($CI->flyUpId);
                                if ($CI->session->userdata("admin_code")) {
                                    redirect('admin/registerUser/success');
                                } else {
                                    redirect('customer/registerUser/success');
                                }
                            }
                            $join_date = date("Y-m-d", strtotime($get_parent[0]['join_date']));
                            $current_date = date("Y-m-d");
                            $timeDiff = strtotime($current_date) - strtotime($join_date);
                            $numberDays = $timeDiff / 86400;  //
                            $count = 0;
                            while ($numberDays >= 30) {
                                $numberDays = $numberDays - 30;
                                $count++;
                            }
                            $depth_level = $get_parent[0]['depth_level'];
                            if ($count % 2 != 0) {
                                // even month
                                if ($login_user_info[0]['type'] != 2) {
                                    $audit_log = array(
                                        'reason_type' => 5, // even month master child odd reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("benifit_from_id"),
                                        'detail' => $CI->reason_type[4],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );

                                    $CI->Customer->createAuditLog($audit_log);
                                } elseif ((((($login_user_info[0]['at_level'] + 1) - $get_parent[0]['at_level']) > $depth_level)) && $get_parent[0]['category'] == 0) {
                                    $audit_log = array(
                                        'reason_type' => 4, // depth level reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("benifit_from_id"),
                                        'detail' => $CI->reason_type[3],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    $CI->Customer->createAuditLog($audit_log);
                                    $data_info = array(
                                        'lost_blance' => $get_parent[0]['lost_blance'] + $CI->profit,
                                    );
                                    $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                } elseif ($get_parent[0]['is_expire'] == 1) {
                                    $audit_log = array(
                                        'reason_type' => 3, // expire reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("benifit_from_id"),
                                        'detail' => $CI->reason_type[2],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    $CI->Customer->createAuditLog($audit_log);
                                }

                                if ($login_user_info[0]['type'] == 2 && ((((($login_user_info[0]['at_level'] + 1) - $get_parent[0]['at_level']) <= $depth_level)) || $get_parent[0]['category'] == 1) && $get_parent[0]['is_expire'] == 0) {
                                    if ($get_parent[0]['is_expire'] == 0) {
                                        $data_info = array(
                                            'total_balance' => $get_parent[0]['total_balance'] + $CI->profit,
                                            'remaning_blance' => $get_parent[0]['remaning_blance'] + $CI->profit,
                                            'even_side_profit' => $get_parent[0]['even_side_profit'] + $CI->profit
                                        );
                                        $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                        $audit_log = array(
                                            'reason_type' => 8,
                                            'user_id' => $get_parent[0]['user_code'],
                                            'created_id' => $CI->session->userdata("benifit_from_id"),
                                            'detail' => $CI->reason_type[8],
                                            'profit' => $CI->take_profit['yes'],
                                            'date' => date('Y-m-d H:i:s'),
                                        );
                                        $CI->Customer->createAuditLog($audit_log);
                                        $data_info_user = array(
                                            'even_childs' => $login_user_info[0]['even_childs'] + 1,
                                            'depth_level' => $login_user_info[0]['depth_level'] + 1,
                                            'category' => $category,
                                        );
                                        $CI->Customer->updateParentById($user_id, $data_info_user);
                                        paymentTransaction($get_parent[0]['user_code']);
                                        bonus($get_parent[0]['parent_id']);
                                        if ($CI->session->userdata("admin_code")) {
                                            redirect('admin/registerUser/success');
                                        } else {
                                            redirect('customer/registerUser/success');
                                        }
                                    } else {
                                        $data_info = array(
                                            'lost_blance' => $get_parent[0]['lost_blance'] + $CI->profit,
                                        );
                                        $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                    }
                                } else {

                                    if ($i == $level_of_tree) {

                                        $fly_up_info = $CI->Customer->getFlyUpById($CI->flyUpId);
                                        $add_profit = array(
                                            'total_balance' => $fly_up_info[0]['total_balance'] + $CI->profit,
                                            'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $CI->profit,
                                        );
                                        $CI->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                                        $audit_log = array(
                                            'user_id' => $CI->flyUpId,
                                            'created_id' => $CI->session->userdata("benifit_from_id"),
                                            'profit' => $CI->take_profit['yes'],
                                            'date' => date('Y-m-d H:i:s'),
                                        );
                                        $CI->Customer->createAuditLog($audit_log);
                                        $parent_update = array(
                                            'even_childs' => $login_user_info[0]['even_childs'] + 1,
                                            'depth_level' => $login_user_info[0]['depth_level'] + 1,
                                            'category' => $category
                                        );
                                        $CI->Customer->updateParentById($user_id, $parent_update);
                                        paymentTransaction($CI->flyUpId);
                                        bonus($CI->flyUpId);
                                        if ($CI->session->userdata("admin_code")) {
                                            redirect('admin/registerUser/success');
                                        } else {
                                            redirect('customer/registerUser/success');
                                        }
                                    }
                                }
                            } else {
                                // odd month

                                if ($login_user_info[0]['type'] != 1) {
                                    $audit_log = array(
                                        'reason_type' => 6, // odd month master child even reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("benifit_from_id"),
                                        'detail' => $CI->reason_type[5],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    $CI->Customer->createAuditLog($audit_log);
                                } elseif ((((($login_user_info[0]['at_level'] + 1) - $get_parent[0]['at_level']) > $depth_level)) && $get_parent[0]['category'] == 0) {

                                    $audit_log = array(
                                        'reason_type' => 4, // depth level reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("benifit_from_id"),
                                        'detail' => $CI->reason_type[3],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    $CI->Customer->createAuditLog($audit_log);
                                    $data_info = array(
                                        'lost_blance' => $get_parent[0]['lost_blance'] + $CI->profit,
                                    );
                                    $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                } elseif ($get_parent[0]['is_expire'] == 1) {
                                    $audit_log = array(
                                        'reason_type' => 3, // expire reason 
                                        'user_id' => $get_parent[0]['user_code'],
                                        'created_id' => $CI->session->userdata("benifit_from_id"),
                                        'detail' => $CI->reason_type[2],
                                        'profit' => $CI->take_profit['no'],
                                        'date' => date('Y-m-d H:i:s'),
                                    );
                                    $CI->Customer->createAuditLog($audit_log);
                                }
                                if ($login_user_info[0]['type'] == 1 && ((((($login_user_info[0]['at_level'] + 1) - $get_parent[0]['at_level']) <= $depth_level)) || $get_parent[0]['category'] == 1) && $get_parent[0]['is_expire'] == 0) {
                                    if ($get_parent[0]['is_expire'] == 0) {
//                                        echo ' '.$login_user_info[0]['at_level'] .$get_parent[0]['at_level'] .$depth_level. $get_parent[0]['name'].$get_parent[0]['category'] ;
//                                        exit;
                                        $data_info = array(
                                            'total_balance' => $get_parent[0]['total_balance'] + $CI->profit,
                                            'remaning_blance' => $get_parent[0]['remaning_blance'] + $CI->profit,
                                            'even_side_profit' => $get_parent[0]['even_side_profit'] + $CI->profit
                                        );
                                        $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                        $audit_log = array(
                                            'reason_type' => 7,
                                            'user_id' => $get_parent[0]['user_code'],
                                            'created_id' => $CI->session->userdata("benifit_from_id"),
                                            'detail' => $CI->reason_type[7],
                                            'profit' => $CI->take_profit['yes'],
                                            'date' => date('Y-m-d H:i:s'),
                                        );
                                        $CI->Customer->createAuditLog($audit_log);
                                        $data_info_user = array(
                                            'even_childs' => $login_user_info[0]['even_childs'] + 1,
                                            'depth_level' => $login_user_info[0]['depth_level'] + 1,
                                            'category' => $category,
                                        );
                                        $CI->Customer->updateParentById($user_id, $data_info_user);
                                        paymentTransaction($get_parent[0]['user_code']);
                                        bonus($get_parent[0]['parent_id']);
                                        if ($CI->session->userdata("admin_code")) {
                                            redirect('admin/registerUser/success');
                                        } else {
                                            redirect('customer/registerUser/success');
                                        }
                                    } else {
                                        $data_info = array(
                                            'lost_blance' => $get_parent[0]['lost_blance'] + $CI->profit,
                                        );
                                        $CI->Customer->updateParentById($get_parent[0]['user_code'], $data_info);
                                    }
                                } else {

                                    if ($i == $level_of_tree) {

                                        $fly_up_info = $CI->Customer->getFlyUpById($CI->flyUpId);
                                        $add_profit = array(
                                            'total_balance' => $fly_up_info[0]['total_balance'] + $CI->profit,
                                            'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $CI->profit
                                        );
                                        $CI->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                                        $audit_log = array(
//                                            'reason_type' => 4, // depth level reason 
                                            'user_id' => $CI->flyUpId,
                                            'created_id' => $CI->session->userdata("benifit_from_id"),
//                                            'detail' => $CI->reason_type[3],
                                            'profit' => $CI->take_profit['yes'],
                                            'date' => date('Y-m-d H:i:s'),
                                        );
                                        $CI->Customer->createAuditLog($audit_log);
                                        $parent_update = array(
                                            'even_childs' => $login_user_info[0]['even_childs'] + 1,
                                            'depth_level' => $login_user_info[0]['depth_level'] + 1,
                                            'category' => $category
                                        );
                                        $CI->Customer->updateParentById($user_id, $parent_update);
                                        paymentTransaction($CI->flyUpId);
                                        bonus($CI->flyUpId);
                                        if ($CI->session->userdata("admin_code")) {
                                            redirect('admin/registerUser/success');
                                        } else {
                                            redirect('customer/registerUser/success');
                                        }
                                    }
                                }
                            }
                            $login_user_info[0]['type'] = $get_parent[0]['type'];
                            $get_parent = $CI->Customer->getParentByUserId($get_parent[0]['parent_id']);
                        }
                    }
                }
            }
        }
    }

}
if (!function_exists('detectBalence')) {

    function detectBalence($code, $amount, $transfer_to = "", $renew_acc = "", $adminid = "", $transfer_by = "") {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $check_user_info = $CI->Customer->getUserByCode($code);
        $index = 0;

        if (count($check_user_info) > 0) {
            $detect_amount_tr_funds = 0;
            $detect_amount_odd_side = 0;
            $detect_amount_fly_side = 0;
            if ($check_user_info[0]['transfer_funds'] >= $amount) {

                $balance_minus = array(
                    "transfer_funds" => ($check_user_info[0]['transfer_funds'] - $amount),
                    "total_balance" => ($check_user_info[0]['total_balance'] - $amount),
                    "remaning_blance" => ($check_user_info[0]['remaning_blance'] - $amount)
                );
                $CI->Customer->updateParentById($code, $balance_minus);
                $payment_data = $CI->Customer->getPaymentLogByUserid($code);
                if (count($payment_data) > 0) {
                    $index = count($payment_data);
                    if ($transfer_to == "re" && $renew_acc != "") {
                        $payment_log = array(
                            'user_id' => $code,
                            'balance_type' => $CI->balance_type[3],
                            'credit' => $amount,
                            'amount' => $payment_data[$index - 1]['amount'] - $amount,
                            'date' => date('Y-m-d H:i:s'),
                            'benifit_to' => $renew_acc,
                            'type' => 9,
                        );
                    } else {
                        if ($transfer_to != "") {
                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[0],
                                'credit' => $amount,
                                'amount' => $payment_data[$index - 1]['amount'] - $amount,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_to' => $transfer_to,
                                'type' => 6,
                                'paid_by' => $transfer_by,
                            );
                        } else
                        if ($adminid != "") {
                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[5],
                                'credit' => $amount,
                                'amount' => $payment_data[$index - 1]['amount'] - $amount,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_from' => $adminid,
                                'type' => 15,
                            );
                        } else {
                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[6],
                                'credit' => $CI->product_price,
                                'amount' => $payment_data[$index - 1]['amount'] - $CI->product_price,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_from' => $CI->session->userdata("benifit_from_id"),
                                'type' => 4,
                            );
                        }
                    }
                    $CI->Customer->createPaymentLog($payment_log);
                }
            } elseif ($check_user_info[0]['odd_side_profit'] + $check_user_info[0]['transfer_funds'] >= $amount) {
                $detect_amount_tr_funds += $check_user_info[0]['transfer_funds'];
                $detect_amount_odd_side = $amount - $detect_amount_tr_funds;
                $balance_minus = array(
                    "transfer_funds" => ($check_user_info[0]['transfer_funds'] - $detect_amount_tr_funds),
                    "odd_side_profit" => ($check_user_info[0]['odd_side_profit'] - $detect_amount_odd_side),
                    "total_balance" => ($check_user_info[0]['total_balance'] - $amount),
                    "remaning_blance" => ($check_user_info[0]['remaning_blance'] - $amount)
                );
                $CI->Customer->updateParentById($code, $balance_minus);
                $payment_data = $CI->Customer->getPaymentLogByUserid($code);
                if (count($payment_data) > 0) {
                    $index = count($payment_data);
                    if ($transfer_to == "re" && $renew_acc != "") {
                        if ($check_user_info[0]['transfer_funds'] != 0) {
                            $index = count($payment_data);
                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[3],
                                'credit' => $detect_amount_tr_funds,
                                'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_tr_funds,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_to' => $renew_acc,
                                'type' => 9,
                            );
                            $CI->Customer->createPaymentLog($payment_log);
                        }
                    } else {
                        if ($transfer_to != "") {
                            if ($check_user_info[0]['transfer_funds'] != 0) {
                                $payment_log = array(
                                    'user_id' => $code,
                                    'balance_type' => $CI->balance_type[0],
                                    'credit' => $detect_amount_tr_funds,
                                    'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_tr_funds,
                                    'date' => date('Y-m-d H:i:s'),
                                    'benifit_to' => $transfer_to,
                                    'type' => 6,
                                    'paid_by' => $transfer_by,
                                );
                                $CI->Customer->createPaymentLog($payment_log);
                            }
                        } else
                        if ($adminid != "") {
                            if ($check_user_info[0]['transfer_funds'] != 0) {
                                $payment_log = array(
                                    'user_id' => $code,
                                    'balance_type' => $CI->balance_type[5],
                                    'credit' => $detect_amount_tr_funds,
                                    'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_tr_funds,
                                    'date' => date('Y-m-d H:i:s'),
                                    'benifit_from' => $adminid,
                                    'type' => 15,
                                );
                                $CI->Customer->createPaymentLog($payment_log);
                            }
                        } else {
                            if ($check_user_info[0]['transfer_funds'] != 0) {
                                $payment_log = array(
                                    'user_id' => $code,
                                    'balance_type' => $CI->balance_type[6],
                                    'credit' => $detect_amount_tr_funds,
                                    'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_tr_funds,
                                    'date' => date('Y-m-d H:i:s'),
                                    'benifit_from' => $CI->session->userdata("benifit_from_id"),
                                    'type' => 4,
                                );
                                $CI->Customer->createPaymentLog($payment_log);
                            }
                        }
                    }
                }
                $payment_data = $CI->Customer->getPaymentLogByUserid($code);
                if (count($payment_data) > 0) {
                    $index = count($payment_data);
                    if ($transfer_to == "re" && $renew_acc != "") {
                        $index = count($payment_data);
                        $payment_log = array(
                            'user_id' => $code,
                            'balance_type' => $CI->balance_type[3],
                            'credit' => $detect_amount_odd_side,
                            'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_odd_side,
                            'date' => date('Y-m-d H:i:s'),
                            'benifit_to' => $renew_acc,
                            'type' => 10,
                        );
                        $CI->Customer->createPaymentLog($payment_log);
                    } else {
                        if ($transfer_to != "") {
                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[0],
                                'credit' => $detect_amount_odd_side,
                                'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_odd_side,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_to' => $transfer_to,
                                'type' => 7,
                                'paid_by' => $transfer_by,
                            );
                        } else
                        if ($adminid != "") {
                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[5],
                                'credit' => $detect_amount_odd_side,
                                'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_odd_side,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_from' => $adminid,
                                'type' => 17,
                            );
//                            $CI->Customer->createPaymentLog($payment_log);
                        } else {
                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[6],
                                'credit' => $detect_amount_odd_side,
                                'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_odd_side,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_from' => $CI->session->userdata("benifit_from_id"),
                                'type' => 11,
                            );
                        }
                        $CI->Customer->createPaymentLog($payment_log);
                    }
                }
            } else {

                $detect_amount_tr_funds += $check_user_info[0]['transfer_funds'];
                $detect_amount_odd_side += $check_user_info[0]['odd_side_profit'];
                $detect_amount_fly_side = $amount - ($detect_amount_tr_funds + $detect_amount_odd_side);
                $balance_minus = array(
                    "transfer_funds" => ($check_user_info[0]['transfer_funds'] - $detect_amount_tr_funds),
                    "odd_side_profit" => ($check_user_info[0]['odd_side_profit'] - $detect_amount_odd_side),
                    "even_side_profit" => ($check_user_info[0]['even_side_profit'] - $detect_amount_fly_side),
                    "total_balance" => ($check_user_info[0]['total_balance'] - $amount),
                    "remaning_blance" => ($check_user_info[0]['remaning_blance'] - $amount)
                );
                $CI->Customer->updateParentById($code, $balance_minus);
                $payment_data = $CI->Customer->getPaymentLogByUserid($code);
                if (count($payment_data) > 0) {
                    $index = count($payment_data);
                    if ($transfer_to == "re" && $renew_acc != "") {

                        if ($check_user_info[0]['transfer_funds'] != 0) {
                            $index = count($payment_data);
                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[3],
                                'credit' => $detect_amount_tr_funds,
                                'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_tr_funds,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_to' => $renew_acc,
                                'type' => 9,
                            );
                            $CI->Customer->createPaymentLog($payment_log);
                        }
                    } else {
                        if ($transfer_to != "") {
                            if ($check_user_info[0]['transfer_funds'] != 0) {
                                $payment_log = array(
                                    'user_id' => $code,
                                    'balance_type' => $CI->balance_type[0],
                                    'credit' => $detect_amount_tr_funds,
                                    'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_tr_funds,
                                    'date' => date('Y-m-d H:i:s'),
                                    'benifit_to' => $transfer_to,
                                    'type' => 6,
                                    'paid_by' => $transfer_by,
                                );
                                $CI->Customer->createPaymentLog($payment_log);
                            }
                        } else
                        if ($adminid != "") {
                            if ($check_user_info[0]['transfer_funds'] != 0) {
                                $payment_log = array(
                                    'user_id' => $code,
                                    'balance_type' => $CI->balance_type[5],
                                    'credit' => $detect_amount_tr_funds,
                                    'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_tr_funds,
                                    'date' => date('Y-m-d H:i:s'),
                                    'benifit_from' => $adminid,
                                    'type' => 15,
                                );
                                $CI->Customer->createPaymentLog($payment_log);
                            }
                        } else {
                            if ($check_user_info[0]['transfer_funds'] != 0) {
                                $payment_log = array(
                                    'user_id' => $code,
                                    'balance_type' => $CI->balance_type[6],
                                    'credit' => $detect_amount_tr_funds,
                                    'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_tr_funds,
                                    'date' => date('Y-m-d H:i:s'),
                                    'benifit_from' => $CI->session->userdata("benifit_from_id"),
                                    'type' => 4,
                                );
                                $CI->Customer->createPaymentLog($payment_log);
                            }
                        }
                    }
                }
                $payment_data = $CI->Customer->getPaymentLogByUserid($code);
                if (count($payment_data) > 0) {
                    $index = count($payment_data);
                    if ($transfer_to == "re" && $renew_acc != "") {

                        if ($check_user_info[0]['odd_side_profit'] != 0) {
                            $index = count($payment_data);
                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[3],
                                'credit' => $detect_amount_odd_side,
                                'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_odd_side,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_to' => $renew_acc,
                                'type' => 10,
                            );
                            $CI->Customer->createPaymentLog($payment_log);
                        }
                    } else {
                        if ($transfer_to != "") {
                            if ($check_user_info[0]['odd_side_profit'] != 0) {
                                $payment_log = array(
                                    'user_id' => $code,
                                    'balance_type' => $CI->balance_type[0],
                                    'credit' => $detect_amount_odd_side,
                                    'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_odd_side,
                                    'date' => date('Y-m-d H:i:s'),
                                    'benifit_to' => $transfer_to,
                                    'type' => 7,
                                    'paid_by' => $transfer_by,
                                );
                                $CI->Customer->createPaymentLog($payment_log);
                            }
                        } else
                        if ($adminid != "") {
                            if ($check_user_info[0]['odd_side_profit'] != 0) {
                                $payment_log = array(
                                    'user_id' => $code,
                                    'balance_type' => $CI->balance_type[5],
                                    'credit' => $detect_amount_odd_side,
                                    'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_odd_side,
                                    'date' => date('Y-m-d H:i:s'),
                                    'benifit_from' => $adminid,
                                    'type' => 17,
                                );
                                $CI->Customer->createPaymentLog($payment_log);
                            }
                        } else {

                            if ($check_user_info[0]['odd_side_profit'] != 0) {
                                $payment_log = array(
                                    'user_id' => $code,
                                    'balance_type' => $CI->balance_type[6],
                                    'credit' => $detect_amount_odd_side,
                                    'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_odd_side,
                                    'date' => date('Y-m-d H:i:s'),
                                    'benifit_from' => $CI->session->userdata("benifit_from_id"),
                                    'type' => 11,
                                );
                                $CI->Customer->createPaymentLog($payment_log);
                            }
                        }
                    }
                }
                $payment_data = $CI->Customer->getPaymentLogByUserid($code);
                if (count($payment_data) > 0) {
                    $index = count($payment_data);
                    if ($transfer_to == "re" && $renew_acc != "") {
                        if ($check_user_info[0]['even_side_profit'] != 0) {
                            $index = count($payment_data);
                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[3],
                                'credit' => $detect_amount_fly_side,
                                'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_fly_side,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_to' => $renew_acc,
                                'type' => 12,
                            );
                            $CI->Customer->createPaymentLog($payment_log);
                        }
                    } else {
                        if ($transfer_to != "") {

                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[0],
                                'credit' => $detect_amount_fly_side,
                                'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_fly_side,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_to' => $transfer_to,
                                'type' => 13,
                                'paid_by' => $transfer_by,
                            );
                        } else
                        if ($adminid != "") {

                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[5],
                                'credit' => $detect_amount_fly_side,
                                'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_fly_side,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_from' => $adminid,
                                'type' => 18,
                            );
//                            $CI->Customer->createPaymentLog($payment_log);
                        } else {
                            $payment_log = array(
                                'user_id' => $code,
                                'balance_type' => $CI->balance_type[6],
                                'credit' => $detect_amount_fly_side,
                                'amount' => $payment_data[$index - 1]['amount'] - $detect_amount_fly_side,
                                'date' => date('Y-m-d H:i:s'),
                                'benifit_from' => $CI->session->userdata("benifit_from_id"),
                                'type' => 14,
                            );
                        }
                        $CI->Customer->createPaymentLog($payment_log);
                    }
                }
            }



            return;
        }
    }

}

if (!function_exists("paymentTransaction")) {

    function paymentTransaction($id = "", $amount = "", $renewal = "") {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $index = 0;
        if ($id != "" && $amount != "" && $renewal != "") {
            $payment_data = $CI->Customer->getPaymentLogByUserid($CI->flyUpId);
            if (count($payment_data) > 0) {
                $index = count($payment_data);
                $payment_log = array(
                    'user_id' => $CI->flyUpId,
                    'balance_type' => $CI->balance_type[3],
                    'dabit' => $amount,
                    'amount' => $payment_data[$index - 1]['amount'] + $amount,
                    'date' => date('Y-m-d H:i:s'),
                    'benifit_from' => $CI->session->userdata("benifit_from_id"),
                    'type' => 5,
                );
                $CI->Customer->createPaymentLog($payment_log);
            } else {

                $payment_log = array(
                    'user_id' => $CI->flyUpId,
                    'balance_type' => $CI->balance_type[3],
                    'dabit' => $amount,
                    'amount' => $amount,
                    'date' => date('Y-m-d H:i:s'),
                    'benifit_from' => $CI->session->userdata("benifit_from_id"),
                    'type' => 5,
                );
                $CI->Customer->createPaymentLog($payment_log);
            }
            return;
        }
        if ($id != "" && $amount != "") {
            $ben_from = "";
            if ($CI->session->userdata("user_code")) {
                $ben_from = $CI->session->userdata("user_code");
            } else {
                $ben_from = $CI->session->userdata("admin_code");
            }
            $payment_data = $CI->Customer->getPaymentLogByUserid($id);

            $index = 0;

            if (count($payment_data) > 0) {
                $index = count($payment_data);
                $payment_log = array(
                    'user_id' => $id,
                    'balance_type' => $CI->balance_type[0],
                    'dabit' => $amount,
                    'amount' => $payment_data[$index - 1]['amount'] + $amount,
                    'date' => date('Y-m-d H:i:s'),
                    'benifit_from' => $ben_from,
                    'type' => 8,
                );
            } else {
                $payment_log = array(
                    'user_id' => $id,
                    'balance_type' => $CI->balance_type[0],
                    'dabit' => $amount,
                    'amount' => $amount,
                    'date' => date('Y-m-d H:i:s'),
                    'benifit_from' => $ben_from,
                    'type' => 8,
                );
            }
            $CI->Customer->createPaymentLog($payment_log);
            return;
        }

        if ($id == $CI->flyUpId) {

            $payment_data = $CI->Customer->getPaymentLogByUserid($id);
//            $index = 0;

            if (count($payment_data) > 0) {
                $index = count($payment_data);
                $payment_log = array(
                    'user_id' => $id,
                    'balance_type' => $CI->balance_type[2],
                    'dabit' => $CI->profit,
                    'amount' => $payment_data[$index - 1]['amount'] + $CI->profit,
                    'date' => date('Y-m-d H:i:s'),
                    'benifit_from' => $CI->session->userdata("benifit_from_id"),
                    'type' => 1,
                );
                $CI->Customer->createPaymentLog($payment_log);
            } else {

                $payment_log = array(
                    'user_id' => $id,
                    'balance_type' => $CI->balance_type[2],
                    'dabit' => $CI->profit,
                    'amount' => $CI->profit,
                    'date' => date('Y-m-d H:i:s'),
                    'benifit_from' => $CI->session->userdata("benifit_from_id"),
                    'type' => 1,
                );
                $CI->Customer->createPaymentLog($payment_log);
            }
        } else if ($id != "") {
            $payment_data = $CI->Customer->getPaymentLogByUserid($id);
            if (count($payment_data) > 0) {
                $index = count($payment_data);

                $payment_log = array(
                    'user_id' => $id,
                    'balance_type' => $CI->balance_type[2],
                    'dabit' => $CI->profit,
                    'amount' => $payment_data[$index - 1]['amount'] + $CI->profit,
                    'date' => date('Y-m-d H:i:s'),
                    'benifit_from' => $CI->session->userdata("benifit_from_id"),
                    'type' => 1,
                );
                $CI->Customer->createPaymentLog($payment_log);
            } else {
                $payment_log = array(
                    'user_id' => $id,
                    'balance_type' => $CI->balance_type[2],
                    'dabit' => $CI->profit,
                    'amount' => $CI->profit,
                    'date' => date('Y-m-d H:i:s'),
                    'benifit_from' => $CI->session->userdata("benifit_from_id"),
                    'type' => 1,
                );
                $CI->Customer->createPaymentLog($payment_log);
            }
        }
    }

}

if (!function_exists('genraterand')) {

    function genraterand() {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $num = date("YW") . rand(101, 999);
//     $num =201403376;   
        $data = $CI->Customer->getUserByCode($num);
        while (count($data) > 0) {
            $num = genraterand();
            $data = $CI->Customer->getUserByCode($num);
        }
        return $num;
    }

}
if (!function_exists('getgallerypics')) {

    function getgallerypics($galleryid) {
        $CI = get_instance();
        $CI->db->where('gallery_id', $galleryid);
        return $CI->db->get('gallery_img')->result_array();
    }

}
if (!function_exists('fetchUserDetail')) {

    function fetchUserDetail($user_code, $odd_even = "") {

        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        if ($user_code != "" && $user_code != 1) {
            $user_html = "";
            $user_info = $CI->Customer->getUserByCode($user_code);

            if ($user_info) {
                $user_html.= "
    <div class='general_box'>
            <div class='general_box_heading' style='text-align:center;'>Distributor Detail</div>
            <div class='print'>
                <table>
                    <tbody>
                        <tr>
                            <td colspan='2' style='text-align: center'><img style ='width: 100px    ' src='" . userImgUrl() . $user_info[0]['picture'] . "'></b></td>
                        </tr>
                        <tr>
                            <td style='font-weight:bold;text-align: right'>Code</td>
                            <td style='text-align: left' >" . $user_info[0]['user_code'] . "</td>
                        </tr>
                        <tr>
                            <td style='font-weight:bold;text-align: right'>Name</td>
                            <td style='text-align: left'>" . $user_info[0]['name'] . "</td>
                        </tr>
                        <tr>
                            <td style='font-weight:bold;text-align: right'>Available Limit</td>
                            <td style='text-align: left'>" . $user_info[0]['remaning_blance'] . "</td>
                        </tr>
                    </tbody>
                </table>
            </div>
    </div>";
                echo json_encode(array('status' => 'success', 'userHTML' => $user_html));
                exit;
            } else {
                echo json_encode(array('status' => 'success', 'userHTML' => "NO Record found"));
                exit;
            }
        } else {
            echo json_encode(array('status' => 'success', 'userHTML' => "NO Record found"));
            exit;
        }
    }

}
if (!function_exists('fetchUserTree')) {

    function fetchUserTree($id, $temp = '') {
        $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $user_html = "";
        $user_info = $CI->Customer->getUserByCode($id);
        if (count($user_info) > 0) {
            if ($temp == 're') {
                $oddEvenMsg = "";
                $odd_or_even = $user_info[0]['odd_childs'] + $user_info[0]['even_childs'];
                if ($odd_or_even % 2 == 0) {
                    $oddEvenMsg = "Odd";
                } else {
                    $oddEvenMsg = "Even";
                }
            }
            $date2 = date('y-m-d');
            $expire_date = date('y-m-d', strtotime($user_info[0]['expired_on']));
            $timeDiff = strtotime($expire_date) - strtotime($date2);
            $numberDays2 = floor($timeDiff / 86400); // 86400 seconds in one day
            $day_left = intval($numberDays2);
            $temp = 0;
            if ($day_left <= 0 || $user_info[0]['is_expire'] == 1) {
                $day_left = "<span style='color:red'>EXPIRED!</span>";
                $temp = 1;
            }
            $user_html.= "
                <div class='general_box'>
            <div class='general_box_heading' style='text-align:center;'>Distributor Detail</div>
            <div class='print'>
                <table>
                    <tbody>
                        <tr>
                            <td colspan='2' style='text-align: center'><img style ='width: 100px    ' src='" . userImgUrl() . $user_info[0]['picture'] . "'></b></td>
                        </tr>
                        <tr>
                            <td style='font-weight:bold;text-align: right'>Code</td>
                            <td style='text-align: left' >" . $user_info[0]['user_code'] . "</td>
                        </tr>
                        <tr>
                            <td style='font-weight:bold;text-align: right'>Name</td>
                            <td style='text-align: left'>" . $user_info[0]['name'] . "</td>
                        </tr>
                        
                    </tbody>
                </table>
            </div>
    </div>
    ";
//            <tr>
//                            <td style='font-weight:bold;text-align: right'>Subscription</td>
//                            <td style='text-align: left'>" . ($temp == 1 ? $day_left : $day_left . ' Days Left') . "</td>
//                        </tr>
            if ($temp == 're') {
                echo json_encode(array('status' => 'success', 'userHTML' => $user_html, 'oddEvenMsg' => $oddEvenMsg));
                exit;
            } else {
                echo json_encode(array('status' => 'success', 'userHTML' => $user_html));
                exit;
            }
        } else {
            echo json_encode(array('status' => 'success', 'userHTML' => "No record exist"));
            exit;
        }
    }

}
