<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Welcome extends CI_Controller {

    /**
     * Index Page for this controller.
     *
     * Maps to the following URL
     * 		http://example.com/index.php/welcome
     * 	- or -  
     * 		http://example.com/index.php/welcome/index
     * 	- or -
     * Since this controller is set as the default controller in 
     * config/routes.php, it's displayed at http://example.com/
     *
     * So any other public methods not prefixed with an underscore will
     * map to /index.php/welcome/<method_name>
     * @see http://codeigniter.com/user_guide/general/urls.html
     */
    public function __construct() {
        parent::__construct();
        $this->load->helper(array('url', 'html', 'form', 'email'));
        $this->layout = 'landing';
        $this->load->model('customer_model', 'Customer');
        $this->load->model('superadmin_model', 'Sadmin');
        $this->load->library('email');
    }

    public function index() {
        if ($this->session->userdata('user_id')) {
//            redirect('customer/home');
        } else {
            
        }
        $this->load->view('welcome_message');
    }

    public function contact() {
        $this->load->view('contact_us');
    }

    public function business() {
        $this->load->view('business');
    }

    public function products() {
        $this->load->view('products');
    }

    public function termsconditions() {
        $this->load->view('termsconditions');
    }

    public function login() {
        if ($this->session->userdata('user_id')) {
            redirect('customer/home');
        } else {
            $data = array();
            $loginId = $this->input->post('loginId');
            $password = $this->input->post('password');
            $this->load->library('form_validation');
            $this->form_validation->set_rules('loginId', 'Login ID', 'trim|required');
            $this->form_validation->set_rules('password', 'Password', 'trim|required');
            if (!($this->form_validation->run() == FALSE)) {


                $data['user_info'] = $this->Customer->loginInfo($loginId, $password);
                if (count($data['user_info']) > 0) {
                    $data['user_active'] = $this->Customer->checkUserActive($loginId);
                    if (count($data['user_active']) > 0) {
                        $this->session->set_userdata('user_id', $data['user_info'][0]['id']);
                        $this->session->set_userdata('user_code', $data['user_info'][0]['user_code']);
                        $this->session->set_userdata('user_name', $data['user_info'][0]['name']);
                        $this->session->set_userdata('user_renew_days_left', date("d-M-Y", strtotime($data['user_info'][0]['expired_on'])));
                        $this->session->userdata('user_renew_days_left');
                        $this->session->unset_userdata('admin_code');

                        $this->session->set_userdata('user_pin', $data['user_info'][0]['pin']);
                        $type = "Customer";
                        $login_tracking = array(
                            "ip_address" => $_SERVER['REMOTE_ADDR'],
                            "created_at " => date('Y-m-d h:i:s'),
                            "access_name" => $loginId,
                            "access_password" => $password,
                            "status" => true,
                            "type" => $type
                        );
                        $this->Sadmin->logintracking($login_tracking);

                        redirect('customer/home');
                    } else {
                        $type = "Customer";
                        $login_tracking = array(
                            "ip_address" => $_SERVER['REMOTE_ADDR'],
                            "created_at " => date('Y-m-d h:i:s'),
                            "access_name" => $loginId,
                            "access_password" => $password,
                            "status" => false,
                            "type" => $type
                        );
                        $this->Sadmin->logintracking($login_tracking);
                        $data['msg'] = "Your account is blocked by admin";
                    }
                } else {
                    $this->Customer->authenticationFailedTracking($this->input->ip_address(), $this->input->post('loginId'), "incorrect Password");
                    $data['msg'] = "User code or Password is incorrect";
                    $type = "Customer";
                        $login_tracking = array(
                            "ip_address" => $_SERVER['REMOTE_ADDR'],
                            "created_at " => date('Y-m-d h:i:s'),
                            "access_name" => $loginId,
                            "access_password" => $password,
                            "status" => false,
                            "type" => $type
                        );
                        $this->Sadmin->logintracking($login_tracking);
                }
            }

            $this->load->view('login', $data);
        }
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */