<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * 
 * @property Customer_model $Customer
 * @property CI_Input $input Description
 * @property CI_Session  $session
 * 
 */
class Customer extends CI_Controller {

//    var $count = 1;


    function __construct() {
        parent::__construct();
//        $this->count++;
        $this->load->helper(array('url', 'html', 'form', 'email'));
        $this->load->library('pagination');
//        $CI = get_instance();
//        $this->load->helper('html');
        if (($this->uri->segment(2) != "login") && ($this->uri->segment(2) != "CheckUserExpire") && ($this->uri->segment(2) != "resetPassword") && ($this->uri->segment(2) != "updatePassword")) {
            $this->layout = 'default';
        }
        error_reporting(E_ALL ^ (E_NOTICE | E_WARNING));
        ini_set('display_errors', 1);
        $this->load->model('customer_model', 'Customer');
    }

    public function index() {
        if ($this->session->userdata('user_id')) {
            redirect('customer/home');
        } else {
            redirect('login');
        }
    }

    public function CheckUserExpire() {
        $users = $this->Customer->CheckUserExpire();
        $today = date("Y-m-d");
        $today_time = date('Y-m-d', strtotime($today));
        foreach ($users as $users_block) {
            $expire = $users_block['expired_on'];
            $expire_time = date('Y-m-d', strtotime($expire));
            if ($today_time > $expire_time) {
                $this->Customer->blockUserByCode($users_block['user_code']);
            }
        }
    }

    public function home() {

        $user_id = $this->session->userdata('user_id');
        if ($user_id) {
            $login_user_info['user_info'] = $this->Customer->getUserById($user_id);
//            $today = date("Y-m-d");
//            $expire = $login_user_info['user_info'][0]['expired_on']; //from db
//            $today_time = strtotime($today);
//            $expire_time = strtotime($expire);
//
//            if ($login_user_info['user_info'][0]['name'] != 'flyup' && $today_time > $expire_time) {
//                $this->Customer->blockUserByCode($login_user_info['user_info'][0]['user_code']);
//            }
            $login_user_info['page_color'] = "home";
            $this->load->view('index', $login_user_info);
        } else {
            redirect('login');
        }
    }

//    public function businessLine($id = "") {
//        if ($this->session->userdata("user_id")) {
//            $data = array();
//            $data['page_color'] = "businessLine";
//            $this->load->view('businessLine', $data);
//        } else {
//            redirect('login');
//        }
//    }
    public function businessLine($id = "") {

        if ($this->session->userdata("user_id")) {
            if ($id == "") {
                $id = $this->session->userdata("user_code");
            }
            if ($this->uri->segment(3) != "") {
                $id = $this->uri->segment(3);
//                echo 'here';
            }
           
            $thismonth = date('Y-m');
            if ($this->input->get()) {
                $data['child'] = $this->Customer->getUserChildrens($id, $_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {
                $radio = "monthlyReport";
                $data['child'] = $this->Customer->getUserChildrens($id, $radio, $thismonth);
            }
            $this->load->view('businessLine2', $data);
        } else {
            redirect('login');
        }
    }

    public function getTree($id = '') {
        $data = array();
        if (intval($this->input->get('id')) <= 0) {
            $id = $this->session->userdata('user_code');
        } else {
            $id = intval($this->input->get('id'));
        }
        $data['tree'] = $this->Customer->getUserChildrens($id);
        $response = $this->load->view('partials/tree_view', $data, TRUE);
        echo $response;
        exit;
    }

    public function viewIntroductions($msg = "") {
        if ($this->session->userdata('user_id')) {
            $data['get_all_childs'] = $this->Customer->getUserTable($this->session->userdata('user_code'));
            if ($msg != "") {

                $data['msg2'] = "Not your child";
            }
            if (count($data['get_all_childs']) <= 0) {
                $data['msg'] = "no child found";
            }
            $data['page_color'] = "viewIntroductions";
            $this->load->view('viewIntroductions', $data);
        } else {
            redirect('login');
        }
    }

    public function customerDetail($id = "") {
        if ($id != "") {
            $parent_id = $this->session->userdata('user_id');

            $user_info['user_info'] = $this->Customer->getUserByIdAndParentId($id, $parent_id);
            if ($user_info['user_info']) {

                $this->load->view('customerDetail', $user_info);
            } else {
                redirect('customer/viewIntroductions/1');
            }
        }
    }

    public function changePin() {
        $data = array();
        $status = true;
        $message = "";
        if ($this->session->userdata('user_id')) {
            if ($this->input->post()) {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('oldPin', 'Old Pin', 'trim|required');
                $this->form_validation->set_rules('newPin', 'New Pin', 'trim|required');
                $this->form_validation->set_rules('confirmPin', 'Confirm New Pin', 'trim|required|matches[newPin]');
                if (!($this->form_validation->run() == FALSE)) {
//Process transfer pending here
                    $oldPin = $this->input->post('oldPin');
                    $check = $this->Customer->checkOldPin($this->session->userdata("user_code"), $oldPin);
                    if (count($check) > 0) {

                        $newPin = $this->input->post('newPin');
                        $this->Customer->updateUserPin($this->session->userdata("user_code"), $newPin);
                        $user = $this->Customer->getUserByCode($this->session->userdata("user_code"));
                        if (count($user) > 0) {


                            template_email_send('pinChange', array('user_code' => $user[0]['user_code'], 'pin' => $user[0]['pin'], 'email' => $user[0]['email']));
                        }
                        $status = true;
                        $message = "Update pin successfully";
                    } else {
                        $status = false;
                        $this->Customer->authenticationFailedTracking($this->input->ip_address(), $this->session->userdata("user_code"), "Incorrect Old Pin");
                        $message = "Old Pin is incorrect";
                    }
                } else {
                    $status = false;
                    $this->Customer->authenticationFailedTracking($this->input->ip_address(), $this->session->userdata("user_code"), "Change Pin Invalid Attempt");
                    $message = validation_errors();
                }
            }
        } else {
            redirect('login');
        }
        $data['status'] = $status;
        $data['message'] = $message;
        $data['page_color'] = "changePin";
        $this->load->view('changePin', $data);
    }

    public function changePassword() {
        $data = array();
        $status = true;
        $message = "";
        if ($this->session->userdata('user_id')) {
            if ($this->input->post()) {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('password', 'Old Password', 'trim|required');
                $this->form_validation->set_rules('newPassword', 'New Password', 'trim|required');
                $this->form_validation->set_rules('confrmPassword', 'Confirm New Password', 'trim|required|matches[newPassword]');
                if ($this->form_validation->run() !== FALSE) {
                    $oldPassword = $this->input->post('password');
                    $check = $this->Customer->checkOldPassword($this->session->userdata("user_code"), $oldPassword);
                    if (count($check) > 0) {

                        $newPassword = $this->input->post('newPassword');
                        $this->Customer->updateUserPassword($this->session->userdata("user_code"), $newPassword);
                        $user = $this->Customer->getUserByCode($this->session->userdata("user_code"));
                        if (count($user) > 0) {


                            template_email_send('passwordChange', array('user_code' => $user[0]['user_code'], 'password' => $user[0]['password'], 'email' => $user[0]['email']));
                        }

                        $status = true;
                        $message = "Update password successfully";
                    } else {
                        $status = false;
                        $this->Customer->authenticationFailedTracking($this->input->ip_address(), $this->session->userdata("user_code"), "Incorrect Old Password");
                        $message = "Old Password is incorrect";
                    }
                } else {
                    $status = false;
                    $this->Customer->authenticationFailedTracking($this->input->ip_address(), $this->session->userdata("user_code"), "Change Password Invalid Attempt");
                    $message = validation_errors();
                }
            }
        } else {
            redirect('login');
        }

        $data['status'] = $status;
        $data['message'] = $message;
        $data['page_color'] = "changePassword";
        $this->load->view('changePassword', $data);
    }

    public function changeEmail() {
        $data = array();
        $status = true;
        $message = "";

        if ($this->session->userdata('user_id')) {

            $data['user_info'] = $this->Customer->getUserById($this->session->userdata('user_id'));
            if (count($data['user_info']) > 0) {

                if ($this->input->post()) {
                    $this->load->library('form_validation');
//                    $this->form_validation->set_rules('email', 'Old Email', 'trim|required');
                    $this->form_validation->set_rules('newEmail', 'New Email', 'trim|required|valid_email');
                    $this->form_validation->set_rules('confrmEmail', 'Confirm New Email', 'trim|required|valid_email|matches[newEmail]');
                    if ($this->form_validation->run() !== FALSE) {
                        $oldEmail = $this->input->post('email');
                        $check = $this->Customer->checkOldEmail($this->session->userdata("user_code"), $oldEmail);
                        if (count($check) > 0) {

                            $newEmail = $this->input->post('newEmail');
                            $this->Customer->updateUserEmail($this->session->userdata("user_code"), $newEmail);
                            $user = $this->Customer->getUserByCode($this->session->userdata("user_code"));
                            if (count($user) > 0) {
                                if ($user[0]['email'] != "") {
                                    template_email_send('emailChange', array('user_code' => $user[0]['user_code'], 'email' => $user[0]['email']));
                                }
                            }
                            $status = true;
                            $message = "Update Email successfully";
                        } else {
                            $status = false;
                            $this->Customer->authenticationFailedTracking($this->input->ip_address(), $this->session->userdata("user_code"), "Incorrect Old Email");
                            $message = "Old Email is incorrect";
                        }
                    } else {
                        $status = false;
                        $this->Customer->authenticationFailedTracking($this->input->ip_address(), $this->session->userdata("user_code"), "Change Email Invalid Attempt");
                        $message = validation_errors();
                    }
                }
            }
        } else {
            redirect('login');
        }

        $data['status'] = $status;
        $data['message'] = $message;
        $data['page_color'] = "changeEmail";
        $this->load->view('changeEmail', $data);
//        redirect('login');
    }

    public function fetchUser($user_code) {
        if ($this->session->userdata('user_code') !== $user_code) {
            fetchUser($user_code);
        } else {
            echo json_encode(array('status' => 'success', 'userHTML' => "You cannot transfer amount in your account"));
            exit;
        }
    }

    public function fetchUserIntro($user_code) {

        fetchUserIntro($user_code);
    }

    public function fetchUserTree($id) {

        if ($id != "" && $id != "1") {

            fetchUserTree($id);
        } else {
            echo json_encode(array('status' => 'success', 'userHTML' => "NO Record found"));
            exit;
        }
    }

    public function fetchUserTree2($id) {

        if ($id != "" && $id != "1") {

            fetchUserTree($id, $te = 're');
        } else {
            echo json_encode(array('status' => 'success', 'userHTML' => "NO Record found"));
            exit;
        }
    }

//    public function genraterand() {
//        $num = date("YW") . rand(101, 999);
////     $num =201403376;   
//        $data = $this->Customer->getUserByCode($num);
//        while (count($data) > 0) {
//            $num = $this->genraterand();
//            $data = $this->Customer->getUserByCode($num);
//        }
//        return $num;
//    }

    public function registerUser($msg = "") {
        if ($this->session->userdata("user_id")) {
            $CI = get_instance();
            $user_info['user_info'] = $this->Customer->getUserById($this->session->userdata("user_id"));
            if (count($user_info['user_info']) > 0) {
                $user_info['products'] = $this->Customer->getProducts();
                if (count($user_info['products']) > 0) {

                    if ($this->input->post()) {
                        if ($this->session->userdata("user_id")) {
//                        echo '<pre>';
//                        print_r($_POST);
//                        exit;

                            $this->load->library('form_validation');
                            $this->form_validation->set_rules('name', 'Name', 'trim|required|xss_clean|max_length[20]');
//                          $this->form_validation->set_rules('fname', 'Father Name', 'trim|required|xss_clean|max_length[20]');
                            $this->form_validation->set_rules('email', 'Email', 'valid_email');
                            $this->form_validation->set_rules('mNo', 'Mobile NO', 'trim|required|xss_clean');
                            $this->form_validation->set_rules('intCode', 'Introducer Code', 'trim|required|xss_clean');
                            $this->form_validation->set_rules('productAmount', 'Product Name', 'trim|required|xss_clean');
                            $this->form_validation->set_rules('pin', 'Pin', 'trim|required|xss_clean');
                            $config['upload_path'] = './uploads/';
                            $config['allowed_types'] = 'gif|jpg|png';
                            $config['max_size'] = '1000';
                            $config['max_width'] = '10244';
                            $config['max_height'] = '7685';
                            $config['file_name'] = 'user_' . time();
                            $this->load->library('upload', $config);
                            if (!($this->form_validation->run() == FALSE)) {
                                $get_parent = $this->Customer->getUserByCode($this->input->post('intCode'));

                                if (count($get_parent) > 0 && $this->input->post('intCode') != 1) {

                                    $product_info = $this->Customer->getProductsByname($this->input->post('productname'));
                                    if (count($product_info) > 0) {
                                        $new_child = $get_parent[0]['depth_level'];
                                        $odd_even = "";
                                        if ($new_child % 2 == 0) {
                                            $odd_even = 'odd';
                                        } else {
                                            $odd_even = 'even';
                                        }

                                        $cor_bit = 0;
                                        $cor_ch = 0;
                                        $answer = $_POST['CourierCharges'];
                                        $CI->product_price = $product_info[0]['actual_amount'];
                                        $comp_profit = $CI->product_price / 2;
                                        $CI->bonus = $comp_profit * 0.2;
                                        $CI->profit = $comp_profit * 0.8;
                                        if ($answer == "yes") {
                                            $cor_bit = 1;
                                            $cor_ch = $CI->cor_charg;
                                            $CI->product_price +=$CI->cor_charg;
                                        }
                                        if ($user_info['user_info'][0]['remaning_blance'] >= $CI->product_price) {

                                            if ($user_info['user_info'][0]['pin'] == trim($this->input->post('pin'))) {
                                                $pic_name = "";
                                                if ($this->upload->do_upload('user_pic')) {
                                                    $thumbnailConfig['source_image'] = BASEDIR . 'uploads/' . $config['file_name'] . '.' . pathinfo($_FILES['user_pic']['name'], PATHINFO_EXTENSION);
                                                    $thumbnailConfig['new_image'] = BASEDIR . 'uploads/' . $config['file_name'] . '_thumb.' . pathinfo($_FILES['user_pic']['name'], PATHINFO_EXTENSION);
                                                    $thumbnailConfig['create_thumb'] = FALSE;
                                                    $thumbnailConfig['maintain_ratio'] = FALSE;
                                                    $thumbnailConfig['width'] = 70;
                                                    $thumbnailConfig['height'] = 70;
                                                    $this->load->library('image_lib');
                                                    $this->image_lib->initialize($thumbnailConfig);
                                                    $upload_data = $this->upload->data();
                                                    $pic_name = $upload_data['file_name'];
                                                }
                                                if ($pic_name == "" && $this->input->post('gender') == "Male") {
                                                    $pic_name = "man.png";
                                                } elseif ($pic_name == "" && $this->input->post('gender') == "Female") {
                                                    $pic_name = "woman.png";
                                                }

                                                $at_level = 0;
                                                if (count($get_parent) > 0) {
                                                    $at_level = $get_parent[0]['at_level'] + 1;
                                                }
                                                if ($get_parent[0]['user_code'] == 1) {

                                                    $at_level = 0;
                                                }
                                                $user_code_new = genraterand();
                                                $password = generateRandomString();
                                                $pin = rand(1909, 9090);

                                                $result = array(
                                                    'user_code' => $user_code_new,
                                                    'name' => $this->input->post('name'),
                                                    'father_name' => $this->input->post('fname'),
                                                    'cnic' => $this->input->post('nic') ? $this->input->post('nic') : '',
                                                    'gender' => $this->input->post('gender') == "Male" ? "1" : "0",
                                                    'marital_status' => $this->input->post('marital'),
                                                    'mobile_no' => $this->input->post('mNo'),
                                                    'email' => $this->input->post('email'),
                                                    'parent_id' => $get_parent[0]['user_code'],
                                                    'home_address' => $this->input->post('pAddress') ? $this->input->post('pAddress') : '',
                                                    'type' => $odd_even == "even" ? 2 : 1,
                                                    'nationality' => $this->input->post('nationality'),
                                                    'k_name' => $this->input->post('kName') ? $this->input->post('kName') : '',
                                                    'k_cnic' => $this->input->post('kCnic') ? $this->input->post('kCnic') : '',
                                                    'k_relation' => $this->input->post('krelation') ? $this->input->post('krelation') : '',
                                                    'courier_charges' => $cor_bit,
                                                    'at_level' => $at_level,
                                                    'picture' => $pic_name,
                                                    'join_date' => date('Y-m-d H:i:s'),
//                                                    'expired_on' => Date('Y-m-d', strtotime("+" . $product_info[0]['expire_after_days'] . "days")),
                                                    'password' => $password,
                                                    'pin' => $pin,
                                                    'access_type' => $this->input->post('productname')== "Membership" ? 0 : 1 ,
                                                );
                                                $last_insert_id = $this->Customer->createNewuser($result);
                                                $user_code = $this->Customer->getUserById($last_insert_id);

                                                $this->session->set_userdata("intro_id", $get_parent[0]['user_code']);
                                                if (count($user_code) > 0) {
                                                    $this->session->set_userdata("benifit_from_id", $user_code[0]['user_code']);
                                                    $product_history = array(
                                                        'user_code' => $user_code[0]['user_code'],
                                                        'user_name' => $user_code[0]['name'],
                                                        'is_paid' => 0,
                                                        'product_name' => $product_info[0]['name'],
                                                        'product_code' => $product_info[0]['code'],
                                                        'date' => date('Y-m-d H:i:s')
                                                    );
                                                    $this->Customer->insertProducthistory($product_history);
                                                }
                                                $this->session->set_userdata("benifit_from_name", $this->input->post('name'));
//                                                if ($user_code[0]['email'] != "") {
//                                                    template_email_send('signUp', array('user_code' => $user_code_new, 'user_name' => $this->input->post('name'), 'mobile_no' => $this->input->post('mNo'), 'password' => $password, "email" => $this->input->post('email'), "pin" => $pin, 'price' => $CI->product_price));
//                                                }
//
//                                                if ($this->input->post('mNo') != '') {
//                                                    sendSMSnewDistributor($this->session->userdata("benifit_from_id"));
//                                                }
//                                                //Sending sms to introducer
//                                                if ($get_parent[0]['mobile_no'] != '') {
//                                                    sendSMSToIntroducer($get_parent[0]['name'], $get_parent[0]['mobile_no'], $user_code[0]['name']);
//                                                }
                                                if ($get_parent[0]['user_code'] == 1) {
                                                    $comp_profit+=$comp_profit;
                                                }
                                                $index = 0;
                                                $payment_data = $this->Customer->getPaymentLogByUserid($CI->flyUpId);
                                                if (count($payment_data) > 0) {

                                                    $index = count($payment_data);

                                                    $payment_log = array(
                                                        'user_id' => $CI->flyUpId,
                                                        'dabit' => $comp_profit + $cor_ch,
                                                        'amount' => $payment_data[$index - 1]['amount'] + $comp_profit + $cor_ch,
                                                        'date' => date('Y-m-d H:i:s'),
                                                        'benifit_from' => $this->session->userdata("benifit_from_id"),
                                                        'type' => 2,
                                                    );
                                                } else {
                                                    $payment_log = array(
                                                        'user_id' => $CI->flyUpId,
                                                        'dabit' => $comp_profit + $cor_ch,
                                                        'amount' => $comp_profit + $cor_ch,
                                                        'date' => date('Y-m-d H:i:s'),
                                                        'benifit_from' => $this->session->userdata("benifit_from_id"),
                                                        'type' => 2,
                                                    );
                                                }
                                                $this->Customer->createPaymentLog($payment_log);

                                                $fly_up_info = $this->Customer->getFlyUpById($CI->flyUpId);
                                                if (count($fly_up_info) > 0) {
                                                    $add_profit = array(
                                                        'total_balance' => $fly_up_info[0]['total_balance'] + $comp_profit + $cor_ch,
                                                        'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $comp_profit + $cor_ch,
                                                    );
                                                    $this->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                                                }
                                                if ($get_parent[0]['user_code'] == 1) {
                                                    redirect('customer/registerUser/success');
                                                }
                                                detectBalence($user_info['user_info'][0]["user_code"], $CI->product_price);
                                                createChild($this->session->userdata('intro_id'));
//                                                bonus($get_parent[0]['parent_id']);
//                                            redirect("customer/createChild");
                                            } else {
                                                $this->Customer->authenticationFailedTracking($this->input->ip_address(), $this->session->userdata("user_code"), "Incorrect Pin");
                                                $user_info['msg'] = "Pin is wrong";
                                            }
                                        } else {
                                            $user_info['msg2'] = "You have not sufficient amount to register distributor";
                                        }
                                    } else {
                                        $user_info['msg'] = "Unknown product";
                                    }
                                } else {
                                    $this->Customer->authenticationFailedTracking($this->input->ip_address(), $user_info['user_info'][0]["user_code"], "Wrong Introducer Code");
//                                    if ($get_parent[0]['is_expire'] == 1) {
//                                        $user_info['msg'] = "The introducer code is Expired.";
//                                    } else {
                                        $user_info['msg'] = "The introducer code is wrong";
//                                    }
                                }
//                        }
                            }
                        }
                    }
                    if ($msg != "") {
                        $user_info['success'] = "Registered new user code <b>" . $this->session->userdata("benifit_from_id") . "</b> and name <b>" . $this->session->userdata("benifit_from_name") . " </b>.";
                    }
                }
            } else {

                $user_info['unknown'] = "Unknown User";
            }
            $user_info['page_color'] = "registerUser";
            $this->load->view('registerUser', $user_info);
        } else {
            redirect('login');
        }
    }

    public function transferFunds($temp = "") {
        if ($this->session->userdata('user_code')) {
            $data = array();
            $status = true;
            $message = "";
            $user_info = $this->Customer->getUserById($this->session->userdata('user_id'));
            if (count($user_info) > 0) {
                if ($this->input->post()) {
                    if ($this->session->userdata("user_code") != trim($this->input->post("code"))) {
                        $this->load->library('form_validation');
                        $this->form_validation->set_rules('code', 'Code', 'trim|required');
                        $this->form_validation->set_rules('amount', 'Amount', 'trim|required');
                        $this->form_validation->set_rules('pin', 'Pin', 'trim|required');
                        if (!($this->form_validation->run() == FALSE)) {
                            $transfer_user_id = $this->input->post("code");
                            $check = $this->Customer->checkIdExist($transfer_user_id);

                            if (count($check) > 0 && $transfer_user_id != 1) {
// user who recieved
//                        $check_user = $this->Customer->getUserById($this->input->post("code"));
                                if ($this->input->post('amount') > 0) {
                                    $check_user_info = $this->Customer->getUserById($this->session->userdata("user_id"));
                                    if (count($check_user_info) > 0) {
                                        if ($check_user_info[0]['remaning_blance'] >= $this->input->post('amount')) {
// success case
                                            if ($check_user_info[0]['pin'] == $this->input->post('pin')) {
                                                detectBalence($this->session->userdata("user_code"), $this->input->post('amount'), $this->input->post("code"));

                                                $balance_plus = array(
                                                    "remaning_blance" => ($check[0]['remaning_blance'] + $this->input->post('amount')),
                                                    "total_balance" => ($check[0]['total_balance'] + $this->input->post('amount')),
                                                    "transfer_funds" => ($check[0]['transfer_funds'] + $this->input->post('amount'))
                                                );
                                                $this->Customer->updateParentById($check[0]['user_code'], $balance_plus);
                                                $this->genrateVoucher($vouchers = array('customer_id' => $check[0]['user_code'], "date" => date('Y-m-d H:i:s'), "type" => "transfer", "amount" => $this->input->post('amount'), "benefit_from" => $this->session->userdata("user_code")));
                                                paymentTransaction($this->input->post("code"), $this->input->post('amount'));
                                                if ($check_user_info[0]['email'] != "") {
                                                    template_email_send('transfer', array('user_code' => $this->input->post("code"), 'amount' => $this->input->post('amount'), "email" => $check_user_info[0]['email'], "myCode" => $this->session->userdata("user_code")));
                                                }
                                                redirect("customer/transferFunds/success");
                                            } else {
                                                $status = false;
                                                $message = "Wrong pin";
                                                $this->Customer->authenticationFailedTracking($this->input->ip_address(), $this->session->userdata("user_code"), "Incorrect Pin");
                                                $data['status'] = $status;
                                                $data['message'] = $message;
                                                $data['user_info'] = $user_info;
                                            }
                                        } else {
                                            $status = false;
                                            $message = "amount exeed than your available limit";
                                            $data['status'] = $status;
                                            $data['message'] = $message;
                                            $data['user_info'] = $user_info;
                                        }
                                    }
                                } else {
                                    $status = false;
                                    $message = "Negitive or Zero amount is not allowed!";
                                    $data['status'] = $status;
                                    $data['message'] = $message;
                                    $data['user_info'] = $user_info;
                                }
                            } else {
                                $status = false;
                                $message = "This id does not exist";
                                $data['status'] = $status;
                                $data['message'] = $message;
                                $data['user_info'] = $user_info;
                            }
                        } else {
                            $status = false;
                            $message = validation_errors();
                            $data['status'] = $status;
                            $data['message'] = $message;
                            $data['user_info'] = $user_info;
                        }
                    } else {
                        $status = false;
                        $message = "You cannot transfer amount in your account";
                        $data['status'] = $status;
                        $data['message'] = $message;
                        $data['user_info'] = $user_info;
                    }
                }
                if ($this->session->userdata('user_id')) {
                    $data['user_info'] = $user_info;
                } else {
                    redirect('login');
                }
            } else {
                $data['unknown'] = "Unknown User!";
            }
            if ($temp != "") {
                $status = true;
                $message = "amount transfer successfully";
                $data['status'] = $status;
                $data['message'] = $message;
                $data['user_info'] = $user_info;
            }
            $data['page_color'] = "transferFunds";
            $this->load->view('transferFunds', $data);
        } else {
            redirect('customer/index');
        }
    }

    public function renewal($temp = "") {
        if ($this->session->userdata("user_id")) {
            $CI = get_instance();
            $data['result'] = $this->Customer->getUserById($this->session->userdata("user_id"));
            if (count($data['result']) > 0) {
                $data['products'] = $this->Customer->getProducts();
                if (count($data['products']) > 0) {
                    if ($this->input->post()) {
                        $this->load->library('form_validation');
                        $this->form_validation->set_rules('intCode', 'Introducer Code', 'trim|required');
                        $this->form_validation->set_rules('renewal_pin', 'Pin', 'trim|required');
                        $this->form_validation->set_rules('prodAmount', 'Product Name', 'trim|required');
                        if ($this->input->post('renewal_amount') <= $data['result'][0]['remaning_blance']) {
                            if ($this->input->post('renewal_pin') == $data['result'][0]['pin']) {
                                if (!($this->form_validation->run() == FALSE)) {
                                    $check = $this->Customer->checkIdExist($this->input->post("intCode"));
                                    if (count($check) > 0 && $this->input->post('intCode') != 1) {
                                        $product_info = $this->Customer->getProductsByname($this->input->post('prodname'));
                                        if (count($product_info) > 0) {
                                            $CI->renewal_amount = $product_info[0]['actual_amount'];

                                            $compProfit = $CI->renewal_amount / 2;

                                            $CI->bonus = $compProfit * 0.2;

                                            $CI->renewal_profit = $compProfit * 0.8;

//                                            $date = date('Y-m-d H:i:s');
//
//                                            $expire_date = date('y-m-d', strtotime($check[0]['expired_on']));
//                                            $timeDiff = strtotime($expire_date) - strtotime($date);
//                                            $numberDays = $timeDiff / 86400;  // 86400 seconds in one day
//                                            $day_left = intval($numberDays);
//                                            if ($day_left <= 0) {
//                                                $renewal = array(
//                                                    "expired_on" => Date('Y-m-d', strtotime("+" . $product_info[0]['expire_after_days'] . "days")),
//                                                    "is_expire" => 0,
////                                            "remaning_blance" => $data['result'][0]['remaning_blance'] - $CI->renewal_amount
//                                                );
//                                            } else {
//
//                                                $renewal = array(
//                                                    "expired_on" => date('Y-m-d', strtotime($check[0]['expired_on'] . ' +' . $product_info[0]['expire_after_days'] . 'days')),
//                                                    "is_expire" => 0,
//                                                );
//                                            }
                                              $renewal = array(
                                                    "access_type" => $this->input->post('prodname') == "Membership" ? 0 : 1 
                                                    
                                                );

                                            $this->Customer->updateParentById($check[0]['user_code'], $renewal);
//                                            $this->genrateVoucher($vouchers = array('customer_id' => $this->session->userdata("user_code"), "date" => date('Y-m-d H:i:s'), "type" => "renewal", "amount" => $CI->renewal_amount, "benefit_to" => $this->flyUpId));
                                            detectBalence($this->session->userdata('user_code'), $CI->renewal_amount, "re", $check[0]['user_code']);
                                            $getFlyUp = $this->Customer->getUserById($this->flyUpId);
                                            if (count($getFlyUp) > 0) {
                                                $flyUp = array(
                                                    "total_balance" => $getFlyUp[0]['total_balance'] + $compProfit,
                                                    "remaning_blance" => $getFlyUp[0]['remaning_blance'] + $compProfit
                                                );
                                                $this->Customer->updateParentById($this->flyUpId, $flyUp);
                                            }
                                            paymentTransaction($this->session->userdata("user_code"), $compProfit, "re");
                                            if ($data['result'][0]['email'] != "") {
                                                template_email_send('renew', array('user_code' => $this->input->post("intCode"), 'amount' => $CI->renewal_amount, "email" => $data['result'][0]['email'], "myCode" => $this->session->userdata('user_code')));
                                            }
                                            $this->session->set_userdata('renewal_benefit_from', $check[0]['user_code']);
                                            renewalProcess($check[0]['parent_id'], $check[0]['type']);
//                                            $get_grand_parent = $this->Customer->getUserByCode($check[0]['parent_id']);
//                                            bonus($get_grand_parent[0]['parent_id'], 'renewal');
//                                            redirect("customer/renewal/sucess");
//                                    $data['success'] = "Renewal successfully";
                                        } else {
                                            $data['msg'] = "Unknown Product";
                                        }
                                    } else {
                                        $data['msg'] = "No user found against this code " . $this->input->post("intCode");
                                    }
                                }
                            } else {
                                $this->Customer->authenticationFailedTracking($this->input->ip_address(), $this->session->userdata("user_code"), "Incorrect Pin");
                                $data['msg'] = "pin is wrong";
                            }
                        } else {
                            $data['msg'] = "You have not sufficien amount to renewal";
                        }
                    }
                    if ($temp != "") {
                        $data['success'] = "Renewal successfully";
                    }
                    $this->load->view('renewal', $data);
                }
            }
        } else {
            redirect('login');
        }
    }

    public function accountStatement($page = "") {
        if ($this->session->userdata("user_id")) {
            $config['uri_segment'] = 3;
            $config['base_url'] = base_url() . '/customer/accountStatement';
            $config['per_page'] = '22';
            $config['total_rows'] = $this->Customer->getAccountStatementCountByUserId($this->session->userdata("user_code"));
            $this->pagination->initialize($config);
            $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
            $data['result'] = $this->Customer->getAccountStatementByUserId($this->session->userdata("user_code"), $config['per_page'], $page);
            $data['paging_link'] = $this->pagination->create_links();
            $data['page_color'] = "accountStatement";
            $this->load->view('accountStatement', $data);
        } else {
            redirect("login");
        }
    }

//    function validateNumber($cell_no) {
//        $is_valid = false;
//        if ($cell_no[0] == 0) {
//            $new_number = substr($cell_no, 1, strlen($cell_no));
//            $new_number = "92" . $new_number;
//            $is_valid = true;
//        } elseif ($cell_no[0] == 9 && $cell_no[1] == 2) {
//            $new_number = $cell_no;
//            $is_valid = true;
//        } elseif ($cell_no[0] == 3) {
//            $new_number = "92" . $cell_no;
//            $is_valid = true;
//        }
//        if ($is_valid) {
//            return $new_number;
//        } else {
//            return false;
//        }
//    }
//
//    function sendSMS($id, $myNo, $mask, $dest, $msg, $pwd) {
//
//        $params = array(
//            'Src_nbr' => $myNo,
//            'Password' => $pwd,
//            'Dst_nbr' => $dest,
//            'Mask' => $mask,
//            'Message' => $msg,
//            'TransactionID' => $id
//        );
//
//        //hiding fatal error exception
//        try {
//            $client = new SoapClient('http://203.82.55.30/CSWS/Service.asmx?wsdl');
//
//            $info = $client->__soapCall("SendSMS", array($params));
//
//            $result = 'SMS has been sent.';
////            $result = $info->SendSMSResult->string[1];
//            return $result;
//        } catch (Exception $e) {
//            //print_r($e);
//        }
//    }
//
//    function sendSkyaimsSMS($to, $msg) {
//
//        $id = time();
//        $myNo = '923154002696';
//        $pwd = smspassword();
//
//
//        $mask = '';
//        $sendsms = $this->sendSMS($id, $myNo, $mask, $to, $msg, $pwd);
//
//        if ($sendsms == 'SMS has been sent.') {
//
//            return true;
//        } else {
//
//            return false;
//        }
//    }
//
//    function sendSMSnewDistributor($id) {
//
////        $new_dist_query = "SELECT * FROM customers WHERE id = " . $id;
////        $new_dist_result = $db->select($new_dist_query);
//        $new_dist_result = $this->Customer->getUserByCode($id);
//        if (count($new_dist_result) > 0) {
//
//            $cell_no = $this->validateNumber($new_dist_result[0]["mobile_no"]);
////        echo $cell_no;
////        exit;
//            if ($cell_no) {
//
//                $to = $cell_no;
//                $msg = "CONGRATS!";
//                $msg .= "\nWELCOME TO Fly Up";
//                $msg .= "\nMR/MS: " . $new_dist_result[0]["name"];
//                $msg .= "\nYOU HAVE JOINED Fly Up ";
//                $msg .= "\nAS " . ($new_dist_result[0]["type"] == 1 ? "ODD" : "EVEN");
//                $msg .= "\nYOUR CODE: " . $new_dist_result[0]["user_code"];
//                $msg .= "\nYOUR PSWD: " . $new_dist_result[0]["password"];
//                $msg .= "\nYOUR PIN: " . $new_dist_result[0]["pin"];
//                $msg .= "\nSECURE YOUR PSWDS";
//                $msg .= "\nWELL WISHER";
//                $msg .= "\nwww.flyup.pk";
//
//                $temp = $this->sendSkyaimsSMS($to, $msg);
//                $introducer_log = array(
//                    "receiver_no" => $cell_no,
//                    "message" => $msg,
//                    "date" => date("y-m-d")
//                );
//                if (!$temp) {
//                    $introducer_log["status"] = 1;
//                }
//                $this->Customer->insertSMS($introducer_log);
//            }
//        }
//    }
//
//    function sendSMSToIntroducer($intro_name, $intro_cell_no, $distributorName) {
////        global $db;
//        $cell_no = $this->validateNumber($intro_cell_no);
//        if ($cell_no) {
//            $to = $cell_no;
//            $msg = "CONGRATS!";
//            $msg .= "\nMR/MS: " . $intro_name;
//            $msg .= "\nYOU HAVE INTRODUCED";
//            $msg .= "\nMR/MS: " . $distributorName;
//            $msg .= "\nWELL WISHER";
//            $msg .= "\nwww.flyup.pk";
//
//            $introducer_log = array(
//                "receiver_no" => $cell_no,
//                "message" => $msg,
//                "date" => date("y-m-d")
//            );
//            if (!$this->sendSkyaimsSMS($to, $msg)) {
//                $introducer_log["status"] = 1;
//            }
//            $this->Customer->insertSMS($introducer_log);
//        }
//    }

    function sendalertsmstodistributor($did) {
//        global $db;
        $data = $this->Customer->getUserByCode($did);
        $dname = $data[0]['name'];
        $mobileno = $data[0]['mobile_no'];
        $dpassword = $data[0]['password'];
        $dpin = $data[0]['pin'];
        $cell_no = validateNumber($mobileno);
        if ($cell_no) {
            $to = $cell_no;
            $dname = urldecode($dname);
            $msg = "Alert !";
            $msg .= "\nMR/MS: " . $dname;
            $msg .= "\nYOUR CODE IS : " . $did;
            $msg .= "\nYOUR PIN CODE IS : " . $dpin;
            $msg .= "\nYOUR PASSWORD CODE IS : " . $dpassword;
            $msg .= "\nWELL WISHER";
            $msg .= "\nwww.flyupint.com";

            $introducer_log = array(
                "receiver_no" => $cell_no,
                "message" => $msg,
                "date" => date("y-m-d")
            );
            if (!sendSkyaimsSMS($to, $msg)) {
                $introducer_log["status"] = 1;
            }
            $this->Customer->insertSMS($introducer_log);
        }
        $this->session->set_flashdata('mymassage', 'Message Sent Successfully!');
        redirect('admin/customerDetail/' . $did);
    }

    public function auditLog($page = 0) {
        if ($this->session->userdata("user_id")) {
            redirect("customer/index");
            $config['uri_segment'] = 3;
            $config['base_url'] = base_url() . '/customer/auditLog';
            $config['per_page'] = '22';
            $config['total_rows'] = $this->Customer->getAudiLogCount();
            $this->pagination->initialize($config);
//            $this->pagination->cur_page = $offset;
            $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
            $data['result'] = $this->Customer->getAuditLog($config['per_page'], $page);
            $data['paglink'] = $this->pagination->create_links();
            $data['page_color'] = "auditLog";
            $this->load->view('auditlog', $data);
        } else {
            redirect("login");
        }
    }

    public function genrateVoucher($voucherInfo = "") {
        $this->Customer->genrateVoucher($voucherInfo);
        return;
    }

    public function resetPassword() {
        $data = array();
        if ($this->input->post()) {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('userCode', 'User Code', 'trim|required');
            if (!($this->form_validation->run() == FALSE)) {
                $user = $this->Customer->get_user_by_userCode($this->input->post('userCode'));
                if (count($user) > 0) {
                    $dataKey = md5(time());
                    $link = site_url('customer/updatePassword/' . $dataKey);
                    if ($user[0]['email'] != "") {
                        template_email_send('fpassword', array('user_code' => $user[0]['user_code'], 'link' => $link, 'email' => $user[0]['email']));
                    }
                    $this->Customer->update_user_key($user[0]['user_code'], $dataKey);
                    $data['msg'] = "Check Your Email";
                } else {
                    $data['msg'] = "Incorrect User Code";
                }
            }
        }
        $this->load->view('resetPassword', $data);
    }

    public function updatePassword($key = "") {
        $data = array();
        $user = $this->Customer->getUserByKey($key);
        if ($user[0]['data_key'] == NULL) {
//            $this->layout = "NULL";
            echo '<strong> session expire </strong>';
            exit;
        } else {
            if ($this->input->post()) {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('password', 'Password', 'required|xss_clean|min_length[5]');
                $this->form_validation->set_rules('conPassword', 'Confirm Password', 'required|xss_clean|matches[password]');
                if (!($this->form_validation->run() == FALSE)) {
                    if ($user[0]['user_code'] != "") {

                        $this->Customer->updateUserPassword($user[0]['user_code'], $this->input->post('password'));
                        $this->Customer->update_user_key($user[0]['user_code'], $user[0]['data_key'] = NULL);
                        $data['msg'] = "Password changed";
                    }
                }
//            redirect(site_url("site/updatePassword"));
            }

            $this->load->view('updatePassword', $data);
        }
    }

    public function logout() {
        $this->session->unset_userdata('user_id');
        $this->session->unset_userdata('user_code');
        $this->session->unset_userdata('user_name');
        $this->session->unset_userdata('user_renew_days_left');
        redirect('login');
    }

}
