<?php

/**
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 * @property CI_DB_active_record $db Description
 */
class Superadmin_model extends CI_Model {
    var $admin_type = 1122;
    var $admin_id = 512;

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function loginInfo($loginId, $password) {
        $this->db->where(array('user_code' => $loginId, 'password' => $password, 'admin_type' => $this->admin_type));
        return $this->db->get('admin_login')->result_array();
    }
    public function logintracking($data) {
        $this->db->insert('login_tracking', $data);
    }

    public function getloginhistory($fromdate = '', $todate = '') {
        if ($fromdate == '' && $todate == '') {
            $fromdate = date("Y-m-01");
            $todate = date("Y-m-t");
        } else
        if ($todate == '') {
            $todate = date("Y-m-d");
        } else
        if ($fromdate == '') {
            $fromdate = date("Y-m-01");
        }
        $this->db->where('created_at >=', $fromdate);
        $this->db->where('created_at <=', $todate);
        $this->db->order_by("UPPER(created_at)","desc");
        return $this->db->get('login_tracking')->result_array();
    }
    public function getipdetail($getip,$startdate,$enddate) {
        $this->db->where('ip_address', $getip);
        $this->db->where('created_at >=', $startdate);
        $this->db->where('created_at <=', $enddate);
        return $this->db->get('login_tracking')->result_array();
    }
    public function getUserById($user_id) {
        $this->db->where('id', $user_id);
//        echo $this->db->last_query();
        return $this->db->get('customer')->result_array();
    }

    public function changesadminpassword($user_id, $data) {
        $this->db->where('user_code', $user_id, 'admin_type', $this->admin_type);
        $this->db->update('admin_login', $data);
    }

    public function adminpasswordchange($user_id, $data) {
        $this->db->where('user_code', $user_id);
        $this->db->update('admin_login', $data);
    }
    public function getUserByCode($user_code) {
        $this->db->where('user_code', $user_code);
//        echo $this->db->last_query();
        return $this->db->get('customer')->result_array();
    }
    public function getUserTable($id = '') {

        if ($id != '')
            $this->db->where('parent_id', $id);
        return $this->db->get('customer')->result_array();
    }
    public function getadmin() {
        $this->db->where('admin_type', 0);
        return $this->db->get('admin_login')->result_array();
    }
    public function getadminbalancereport() {
//       $this->db->where('admin_type', 0);
        return $this->db->get('admin_balance_history')->result_array();
    }
    public function currentbalance($id = '') {
        $this->db->where('user_code', $id);
        return $this->db->get('admin_login')->result_array();
    }

    public function tracking($fromdate = '', $todate = '') {
        if ($fromdate == '' && $todate == '') {
            $fromdate = date("Y-m-01");
            $todate = date("Y-m-t");
        } else
        if ($todate == '') {
            $todate = date("Y-m-d");
        } else
        if ($fromdate == '') {
            $fromdate = date("2014-01-01");
        }
        $sql = "SELECT ip_address,count(*) as totalAttempts,
			count(CASE status WHEN 1 THEN 1 END) as successfull,
			count(CASE status WHEN 0 THEN 1 END) as fail,max(`created_at`) as maxdate,min(`created_at`) as mindate
			FROM login_tracking Where created_at >= '" . $fromdate . "' AND created_at <= '" . $todate . "' group by ip_address";
//			FROM login_tracking Where " . makeWhereClause("date",true) . "group by ip_address";
        $result = $this->db->query($sql)->result_array();
        return $result;
    }
    public function allocatebalance($id, $data) {

        $got_user = $this->currentbalance($id);
        $got_user[0]['balance']; //old balance of admin
        $sadmin_balance = $this->currentbalance($this->admin_id);
        $sadmin_balance[0]['balance'];
        $newbalance = $got_user[0]['balance'] + $data;
        $newadminbalance = $sadmin_balance[0]['balance'] - $data;
        $update_balance = array("balance" => $newbalance);
        $update_admin_balance = array("balance" => $newadminbalance);
        //admin update
        $this->db->where('user_code', $id);
        $this->db->update('admin_login', $update_balance);
        //super admin update
        $this->db->where('user_code', $this->admin_id);
        $this->db->update('admin_login', $update_admin_balance);
        return $got_user[0]['balance'];
    }
    public function balancehistory($data) {
        $this->db->insert('admin_balance_history', $data);
    }
    public function createAdminBalanceHistory($data) {
        $this->db->insert('payment_log', $data);
    }
}
