<?php

class Admin_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function loginInfo($loginId, $password) {
        $this->db->where(array('user_code' => $loginId, 'password' => $password));
        $this->db->where('admin_type', 0);
        return $this->db->get('admin_login')->result_array();
    }

    public function salesHistory($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "") {
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {
//            echo 'there';
//            exit;
            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        }
        if ($id != "") {
            $this->db->where('user_id', $id);
        }
        $this->db->where('(type = 4 OR type = 11 OR type = 14 OR balance_type = "signUp")');
        $this->db->where('balance_type = "signUp"');
//        $this->db->limit($limit, $start);
//        $this->db->group_by("user_id");
        $this->db->order_by("date", "asc");
        $kk = $this->db->get('payment_log')->result_array();
//        echo $this->db->last_query();//exit;
//        return $this->db->get('payment_log')->result_array();
        return $kk;
    }

    public function getPaidHistory($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "", $paidUnpaid="") {
        if ($paidUnpaid == 'Paid' || $paidUnpaid == '') {
            if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {
                $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
                $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
            } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {
//            echo 'there';
//            exit;
                $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
            }
            if ($id != "") {
                $this->db->where('benifit_to', $id);
            }
            $this->db->where(array('user_id' => 12, 'balance_type' => 'paid'));
            $this->db->order_by("date", "asc");
            $kk = $this->db->get('payment_log')->result_array();
//        echo $this->db->last_query();//exit;
//        return $this->db->get('payment_log')->result_array();
            return $kk;
        } else {
          
                if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {
                    $this->db->where('DATE_FORMAT(  `join_date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
                    $this->db->where('DATE_FORMAT(  `join_date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
                } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {
//            echo 'there';
//            exit;
                    $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
                }
                if ($id != "") {
                    $this->db->where('user_code', $id);
                }
                $this->db->where('remaning_blance > 0');

                $kk = $this->db->get('customer')->result_array();
//        echo $this->db->last_query();//exit;
//        return $this->db->get('payment_log')->result_array();
                return $kk;
            
        }
    }

    public function getsalesHistoryLogCount($getm = '') {
        $this->db->where('(type = 4 OR type = 11 OR type = 14 OR balance_type = "signUp")');
        $this->db->where('balance_type = "signUp"');
        if ($getm != '')
            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $getm . '"');
        return $this->db->count_all_results('payment_log');
    }

    public function getsalesHistoryLogCountWhere($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "") {

        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('date >= ', $startDate);
            $this->db->where('date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        }
        if ($id != "") {
            $this->db->where('user_id', $id);
        }
        $this->db->where('(type = 4 OR type = 11 OR type = 14 OR balance_type = "signUp")');
        $this->db->where('balance_type = "signUp"');
        $this->db->from('payment_log');
        return $this->db->count_all_results();
    }

//    public function flyUpHistory() {
//        $this->db->where(array('type' => 1));
//        return $this->db->get('payment_log')->result_array();
//    }

    public function getAdminByCode($user_code) {
        $this->db->where('user_code', $user_code);
//        echo $this->db->last_query();
        return $this->db->get('admin_login')->result_array();
    }

    public function updateAdminByCode($user_id, $data) {
        $this->db->where('user_code', $user_id);
        $this->db->update('admin_login', $data);
    }

    public function adminBalanceHistory($user_id) {
        $this->db->where('user_code', $user_id);
        return $this->db->get('admin_balance_history')->result_array();
    }

    public function addnews($getnews) {
        $this->db->insert('news', $getnews);
    }

    public function addgallery($getgallery) {
        $this->db->insert('gallery', $getgallery);
        return $this->db->insert_id();
    }

    public function addgalleryimg($getgalleryimg) {
        $this->db->insert('gallery_img', $getgalleryimg);
    }

    public function getgallery($galleryid = '') {
        if ($galleryid != '') {
            $this->db->where('id', $galleryid);
        }
        $this->db->order_by("id", "desc");
        return $this->db->get('gallery')->result_array();
    }

    public function getallgallery($galleryid) {
        $this->db->where('gallery_id', $galleryid);
        return $this->db->get('gallery_img')->result_array();
    }

    public function getgalleryimagename($galleryid) {
        $this->db->where('id', $galleryid);
        return $this->db->get('gallery')->row()->gallery_image;
    }

    public function updatepic($imageid, $data) {
        $this->db->where('id', $imageid);
        return $this->db->update('gallery_img', $data);
    }

    public function updategallerypic($galleryid, $imagename) {
        $this->db->where('id', $galleryid);
        $this->db->update('gallery', $imagename);
    }

    public function getnews($newsid = '') {
        if ($newsid != '') {
            $this->db->where('id', $newsid);
        }
        $this->db->order_by("id", "desc");
        return $this->db->get('news')->result_array();
    }

    public function getvoucher($voucherid) {
        $this->db->where('payment_id ', $voucherid);
        return $this->db->get('payment_log')->result_array();
    }

    public function getadmintransferhistory($adminid, $filter_radio = "", $month = "", $startDate = "", $endDate = "", $touserid = "") {
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
//            if($id !="")
//            {
//            $this->db->where('created_id', $id);
//            }
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        }
        if ($touserid != '') {
            $this->db->where('benifit_to', $touserid);
        }
        $this->db->where(array('user_id' => $adminid, 'balance_type' => "Admin transfer", 'type' => 20));
        if ($month == "all" || $month == "2014-02") {
            $this->db->or_where('(payment_id = 2 OR payment_id = 35 OR payment_id = 305 OR payment_id = 446 OR payment_id = 448)');
        }
        $kk = $this->db->get('payment_log')->result_array();
//        echo $this->db->last_query();
        return $kk;
    }

//    public function getbalancetransferreport($touserid='') {
//        if($touserid != ''){
//            $this->db->where('benifit_to', $touserid);
//        }
//        $this->db->where('user_id', $adminid);
//        $this->db->where('balance_type = "Admin transfer" OR balance_type = "transfer"');
//        $this->db->where('type = 20 OR type = 6');
//        return $this->db->get('payment_log')->result_array();
//    }
    public function updatenews($news_id, $data) {
        $this->db->where('id', $news_id);
        $this->db->update('news', $data);
    }

    public function createBalanceHistory($user_id, $data) {
        $this->db->where('user_code', $user_id);
        $this->db->insert('admin_balance_history', $data);
    }

    public function createAdminBalanceHistory($data) {
        $this->db->insert('payment_log', $data);
    }

    public function getadminpaymentlog($adminid) {
        $this->db->where('user_id', $adminid);
        $names = array('Admin transfer', 'Admin Register', 'From Super Admin');
        $this->db->or_where_in('balance_type', $names);
        $this->db->join('type_statment', 'type_statment.id = payment_log.type');
        //        echo $this->db->last_query();exit();
        return $this->db->get('payment_log')->result_array();
    }

    public function getstatmentbyid($statmentid) {
        $this->db->where('id', $statmentid);
        return $this->db->get('type_statment')->row()->statment;
    }

    public function getAuditLog($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "",$bonus="") {

        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
//            if($id !="")
//            {
//            $this->db->where('created_id', $id);
//            }
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        } //else {
//            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
//            $this->db->where('parent_id', $id);
        //}
        if ($id != "") {
            $this->db->where('created_id', $id);
        }
//        $this->db->limit($limit, $start);
        $this->db->order_by("id", "asc");
        if($bonus =="bonus")
        {

            return $this->db->get('bonus_audit_log')->result_array();   
        }
        return $this->db->get('audit_log')->result_array();
        echo $this->db->last_query();
        exit;
    }

    public function getAudiLogCountWhere($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "") {

        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
//            if($id !="")
//            {
//            $this->db->where('created_id', $id);
//            }
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        } //else {
//            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
//            $this->db->where('parent_id', $id);
        //}
        if ($id != "") {
            $this->db->where('created_id', $id);
        }
        $this->db->from('audit_log');
        return $this->db->count_all_results();
    }

    public function eMoneyIssue($filter_radio = "", $month = "", $startDate = "", $endDate = "") {
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('date >= ', $startDate);
            $this->db->where('date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        } //else {
        $this->db->where('user_id', 12);
        $this->db->where('(balance_type = "transfer" OR balance_type = "paid" OR balance_type = "Admin transfer")');

        return $this->db->get('payment_log')->result_array();
    }

    public function eMoneyUsed($filter_radio = "", $month = "", $startDate = "", $endDate = "") {
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('date >= ', $startDate);
            $this->db->where('date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        } //else {
//        $this->db->where('(credit = 7000 OR credit = 7300 OR credit= 14000 OR credit= 14300)');
        $this->db->where('balance_type', 'signUp');
        return $this->db->get('payment_log')->result_array();
    }

    public function eMoneyUnused($filter_radio = "", $month = "", $startDate = "", $endDate = "") {
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('join_date >= ', $startDate);
            $this->db->where('join_date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
        } //else {

        $this->db->where('user_code !=', 1);
        $this->db->where('remaning_blance >', 0);
        return $this->db->get('customer')->result_array();
//        return $this->db->get('payment_log')->result_array();
    }

    public function getCustomerLog($filter_radio = "", $month = "", $startDate = "", $endDate = "") {

        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('join_date >= ', $startDate);
            $this->db->where('join_date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('(DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '")');
        } //else {
        $this->db->where('type', 1);
        $this->db->where('user_code >', '2');
        $this->db->order_by("id", "asc");
        $this->db->from('customer');
        $data['totalOddCustomer'] = $this->db->count_all_results();
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('join_date >= ', $startDate);
            $this->db->where('join_date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('(DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '")');
        }
        $this->db->where('user_code >', '2');
        $this->db->order_by("id", "asc");
        $this->db->from('customer');
        $data['totalCustomer'] = $this->db->count_all_results();
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('join_date >= ', $startDate);
            $this->db->where('join_date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('(DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '")');
        }
        $this->db->where('type', 2);
        $this->db->where('user_code >', '2');
        $this->db->order_by("id", "asc");
        $this->db->from('customer');
        $data['totalEvenCustomer'] = $this->db->count_all_results();
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('date >= ', $startDate);
            $this->db->where('date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('(DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '")');
        }
        $this->db->where('user_id', 1);
        $this->db->where('(balance_type IS NULL OR balance_type = "flyUp" )');
        $this->db->select_sum('dabit');
        $data['profit'] = $this->db->get('payment_log')->result_array();

        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('join_date >= ', $startDate);
            $this->db->where('join_date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('(DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '")');
        }
        $this->db->where('user_code >', '2');
        $this->db->select_sum('remaning_blance');
        $this->db->order_by("id", "asc");
        $data['payAble'] = $this->db->get('customer')->result_array();
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('date >= ', $startDate);
            $this->db->where('date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('(DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '")');
        }
        $this->db->where('user_id', 12);
        $this->db->where('(balance_type = "transfer" OR balance_type = "paid" OR balance_type = "Admin transfer")');
        $this->db->select_sum('credit');
        $data['emoney_issue'] = $this->db->get('payment_log')->result_array();
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('date >= ', $startDate);
            $this->db->where('date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('(DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '")');
        }
//        $this->db->where('(credit = 7000 OR credit = 7300 OR credit= 14000 OR credit= 14300)');
        $this->db->where('balance_type', 'signUp');
        $this->db->select_sum('credit');
        $data['emoney_use'] = $this->db->get('payment_log')->result_array();
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('join_date >= ', $startDate);
            $this->db->where('join_date <= ', $endDate);
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('(DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '")');
        } //else {
        $this->db->where('(user_code > 2)');
        $this->db->select_sum('remaning_blance');
        $data['total_unused'] = $this->db->get('customer')->result_array();
//         echo $this->db->last_query();
//$this->db->get('payment_log')->result_array();
//        $this->db->get('payment_log')->result_array();
//        echo $this->db->last_query();
//        exit;
        return $data;
    }

    public function getCustomerCountWhere($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "") {

        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('date >= ', $startDate);
            $this->db->where('date <= ', $endDate);
//            if($id !="")
//            {
//            $this->db->where('created_id', $id);
//            }
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        } //else {
//            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
//            $this->db->where('parent_id', $id);
        //}
        if ($id != "") {
            $this->db->where('created_id', $id);
        }
        $this->db->where('user_code >', '2');
        $this->db->from('audit_log');
        return $this->db->count_all_results();
    }

    public function getAudiLogCount() {
        return $this->db->count_all_results('audit_log');
    }

    public function getTransferHistoryLogCount() {
//        $this->db->where(array('type' => 6));
        $this->db->where('(type = 6 OR type = 7 OR type = 13)');
        return $this->db->count_all_results('payment_log');
    }

    public function transferHistory($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "") {
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
//            if($id !="")
//            {
//            $this->db->where('created_id', $id);
//            }
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        } //else {
//            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
//            $this->db->where('parent_id', $id);
        //}
        if ($id != "") {
            $this->db->where('user_id', $id);
        }
//        $this->db->limit($limit, $start);
        $this->db->where('(type = 6 OR type = 7 OR type = 13)');
//        $this->db->where(array('type' => 6));
        return $this->db->get('payment_log')->result_array();
    }

    public function getTransferHistoryLogCountWhere($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "") {

        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
//            if($id !="")
//            {
//            $this->db->where('created_id', $id);
//            }
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        } //else {
//            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
//            $this->db->where('parent_id', $id);
        //}
        if ($id != "") {
            $this->db->where('user_id', $id);
        }
        $this->db->where('(type = 6 OR type = 7 OR type = 13)');
//        $this->db->where(array('type' => 6));
        $this->db->from('payment_log');
        return $this->db->count_all_results();
    }

    public function getDirectHistoryLogCount() {
        $this->db->where(array('type' => 3));
        return $this->db->count_all_results('payment_log');
    }

    public function directHistory($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "") {
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
//            if($id !="")
//            {
//            $this->db->where('created_id', $id);
//            }
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        } //else {
//            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
//            $this->db->where('parent_id', $id);
        //}
        if ($id != "") {
            $this->db->where('user_id', $id);
        }
//        $this->db->limit($limit, $start);
        $this->db->where(array('type' => 3));
        return $this->db->get('payment_log')->result_array();
    }

    public function getDirectHistoryLogCountWhere($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "") {

        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
//            if($id !="")
//            {
//            $this->db->where('created_id', $id);
//            }
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        } //else {
//            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
//            $this->db->where('parent_id', $id);
        //}
        if ($id != "") {
            $this->db->where('user_id', $id);
        }
        $this->db->where(array('type' => 3));
        $this->db->from('payment_log');
        return $this->db->count_all_results();
    }

    public function getUserCodeCount() {
        $this->db->select('user_code');
        $this->db->where('user_code > 2');
        return $this->db->count_all_results('customer');
    }

    public function getUserCode($filter_radio = "", $month = "") {
        if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        }
        $this->db->select('user_code');
//        $this->db->where('user_code > 2');
//        $this->db->limit($limit, $start);
        $kk = $this->db->get('customer')->result_array();
//        echo $this->db->last_query();
        return $kk;
    }

    public function getFlyupHistoryLogCount() {
        $this->db->where(array('type' => 1));
        return $this->db->count_all_results('payment_log');
    }

    public function flyUpHistory($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "") {
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
//            if($id !="")
//            {
//            $this->db->where('created_id', $id);
//            }
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        } //else {
//            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
//            $this->db->where('parent_id', $id);
        //}
        if ($id != "") {
            $this->db->where('user_id', $id);
        }
//        $this->db->limit($limit, $start);
        $this->db->where(array('type' => 1));
        return $this->db->get('payment_log')->result_array();
    }

    public function getFlyupHistoryLogCountWhere($filter_radio = "", $month = "", $startDate = "", $endDate = "", $id = "") {

        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {

            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
//            if($id !="")
//            {
//            $this->db->where('created_id', $id);
//            }
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {

            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        } //else {
//            $this->db->where('DATE_FORMAT(`join_date`, "%Y-%m") = "' . $month . '"');
//            $this->db->where('parent_id', $id);
        //}
        if ($id != "") {
            $this->db->where('user_id', $id);
        }
        $this->db->where(array('type' => 1));
        $this->db->from('payment_log');
        return $this->db->count_all_results();
    }

    public function getProductHistory($id = "") {
        if ($id != "") {
            $this->db->where('id', $id);
            return $this->db->get('products_history')->result_array();
        } else {
            return $this->db->get('products_history')->result_array();
        }
    }

    public function get_Paid_UnPain_History($id = "", $paidUnpaid = "", $filter_radio = "", $month = "", $startDate = "", $endDate = "") {
        if ($filter_radio == "dailyReport" && $startDate != "" && $endDate != "") {
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($startDate)));
            $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($endDate)));
        } else if ($filter_radio == "monthlyReport" && $month != "" && $month != "all") {
//            echo 'there';
//            exit;
            $this->db->where('DATE_FORMAT(`date`, "%Y-%m") = "' . $month . '"');
        }
        if ($id != "") {
            $this->db->where('user_code', $id);
        }
//        echo $paidUnpaid;
//        exit;
        if ($paidUnpaid != "" && $paidUnpaid != 2) {
//            echo 'there';
//            exit;
            if ($paidUnpaid == 3) {
                $paidUnpaid = 0;
            }
            $this->db->where('is_paid', $paidUnpaid);
        }

        $kk = $this->db->get('products_history')->result_array();
//        echo $this->db->last_query();
        return $kk;
    }

    public function updateProductHistory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('products_history', $data);
    }

    public function getCustomerLogCount() {
        $this->db->where('user_code >', '2');
        return $this->db->count_all_results('customer');
    }

    public function getunauthorizedreport($code = '', $fromdate = '', $todate = '') {
        if ($fromdate == '' && $todate == '') {
            $fromdate = date("Y-m-01");
            $todate = date("Y-m-t");
        } else
        if ($todate == '') {
            $todate = date("Y-m-d");
        } else
        if ($fromdate == '') {
            $fromdate = date("Y-m-01");
        }
        if ($code != '') {
            $this->db->where('user_code', $code);

            $getuser = $this->db->get('customer')->result_array();
//            echo $this->db->last_query();echo "<pre/>";print_r($getuser);exit;
            if (count($getuser) > 0) {
                $this->db->where('access_name', $code);
            }
        }
//        echo date("Y-m-d", time()+86400);echo $this->db->last_query();        
        $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) >=', date("Y-m-d", strtotime($fromdate)));
        $this->db->where('DATE_FORMAT(  `date` ,  "%Y-%m-%d" ) <=', date("Y-m-d", strtotime($todate)));

        $this->db->order_by("UPPER(date)", "desc");
        $kk = $this->db->get('authentication_failed_tracking')->result_array();
//          echo $this->db->last_query();
        return $kk;
    }

    public function getUserEarnBalance($id) {
        $this->db->where('type = 3 OR  type = 1');
        $this->db->where('user_id', $id);
        $this->db->order_by("payment_id", "desc");
        return $this->db->get('payment_log')->result_array();
        echo $this->db->last_query();
        exit;
    }

    public function getUserEarnBalanceCount() {

        $this->db->where('user_id', 12);
        $this->db->where('(balance_type = "transfer" OR balance_type = "paid" OR balance_type = "Admin transfer")');
        return $this->db->count_all_results('payment_log');
    }

    public function getUserPaidBalance($id) {
        $this->db->where(array('type' => 15, 'user_id' => $id));

        return $this->db->get('payment_log')->result_array();
    }

    public function getUserDirectEarning($user_code) {
        $this->db->where('user_id', $user_code);
        $this->db->where('balance_type', "direct");
        return $this->db->get('payment_log')->result_array();
    }

    public function getUserFlyUpEarning($user_code) {
        $this->db->where('user_id', $user_code);
        $this->db->where('balance_type', "flyUp");
        return $this->db->get('payment_log')->result_array();
    }

    public function getUserTransferBalance($user_code) {
        $this->db->where('user_id', $user_code);
        $this->db->where('balance_type', "transfer");
        $this->db->where('credit > 0');
        return $this->db->get('payment_log')->result_array();
    }

    public function getUserReceivedBalance($user_code) {
        $this->db->where('benifit_to', $user_code);
        $this->db->where('(balance_type = "paid" OR balance_type = "transfer" )');
        return $this->db->get('payment_log')->result_array();
    }
    public function getUserBonusBalance($user_code) {
        $this->db->where('user_id', $user_code);
        $this->db->where('(balance_type = "bonus")');
        return $this->db->get('payment_log')->result_array();
    }

}

