<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 4.3.2 or newer
 *
 * @package		CodeIgniter
 * @author		ExpressionEngine Dev Team
 * @copyright	Copyright (c) 2008 - 2009, EllisLab, Inc.
 * @license		http://codeigniter.com/user_guide/license.html
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
// ------------------------------------------------------------------------

/**
 * CodeIgniter Reprice Helpers
 *
 * @package		CodeIgniter
 * @subpackage	Helpers
 * @category	Helpers
 * @author		ExpressionEngine Dev Team
 * @link		http://codeigniter.com/user_guide/helpers/reprice_helper.html
 */
// ------------------------------------------------------------------------

function img_url($img, $complete_path = '') {
    $CI = & get_instance();
    return $CI->config->slash_item('base_url') . 'images/' . $complete_path . $img;
}

if (!function_exists('getUserName')) {

    function getUserName($user_code) {
         $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $CI->db->where('user_code',$user_code);
       return $CI->db->get('customer')->row()->name;
    }

}
if (!function_exists('getparentcode')) {

    function getparentcode($user_code) {
         $CI = get_instance();
        $CI->load->model('customer_model', 'Customer');
        $CI->db->where('user_code',$user_code);
       return $CI->db->get('customer')->row()->parent_id;
    }

}
if (!function_exists('smspassword')) {

    function smspassword() {
        $CI = & get_instance();
        return 'sky321';
    }

}
/**
 * Generate Random Password
 *
 * @access	public
 * @return	bool
 */
if (!function_exists('adminImageUrl')) {

    function adminImageUrl() {
        $CI = & get_instance();
        return $CI->config->slash_item('base_url_admin_images');
    }

}
if (!function_exists('userImgUrl')) {

    function userImgUrl() {
        $CI = & get_instance();
        return $CI->config->slash_item('base_url_customer_images');
    }

}
if (!function_exists('getstatment')) {

    function getstatment($getid) {
        $CI = & get_instance();
        $CI->db->where(array('id' => $getid));
        $jj = $CI->db->get('type_statment')->result_array();
        if (count($jj) > 0)
            return $jj[0]['statment'];
        return 0;
    }

}
if (!function_exists('compnyImageUrl')) {

    function compnyImageUrl() {
        $CI = & get_instance();
        return $CI->config->slash_item('base_url_compny_images');
    }

}
if (!function_exists('usersImageUrl')) {

    function usersImageUrl() {
        $CI = & get_instance();
        return $CI->config->slash_item('base_url_users_images');
    }

}
if (!function_exists('addrs')) {

    function addrs($amount) {
        if (isset($amount) && intval($amount) > 0) {

            return $amount;
        } else {
            return "0";
        }
    }

}
if (!function_exists('mainImageUrl')) {

    function mainImageUrl() {
        $CI = & get_instance();
        return $CI->config->slash_item('base_url_main_images');
    }

}
if (!function_exists('makeWhereClause')) {

    function makeWhereClause($colName, $includeStartDate = true) { //this function should always come after the above code of setting start date and end date
        global $startDate, $endDate, $monthName, $currentDate;
        if ($monthName != "All") {
            //NOTE: %m/%d/%Y is not working so format should not be changed
            $where = "";
            if ($includeStartDate) {
$where = $where . " DATE_FORMAT( `" . $colName . "` , '%Y/%m/%d' ) >= '" . $startDate . "' AND ";
$where = $where . " DATE_FORMAT( `" . $colName . "` , '%Y/%m/%d' ) <= '" . $endDate . "'";
            } else {
$where = " DATE_FORMAT( `" . $colName . "` , '%Y/%m/%d' ) < '" . $startDate . "' ";
            }

            return $where;
        } else {
            $where = "DATE_FORMAT( `" . $colName . "` , '%Y/%m/%d' ) <= '" . $endDate . "'";
            ;
            return $where;
        }
    }

}


if (!function_exists('getFilters')) {

    function getFilters($selectedMonth = 'all', $start_date = '', $end_date = '', $selected_radio = '',$method='POST',$action='') {
        $CI = get_instance();
//        $temp = '';
//        echo 'there';
//        exit;
        if($CI->uri->segment(3) !="")
        {
         $id =   '/'.$CI->uri->segment(3);
//         $temp = '/'.$id;
        }
        $starting_month = '2014/01/01';
        $html = '<form method = "'.$method.'" class="helperc" action ="'.$action.$id.'">';
        $html .= '<div class="mew"><input type="radio" id="monthlyReport" name="filter_radio" value="monthlyReport" ' . (($selected_radio == 'monthlyReport') ? 'checked' : '') . '/><label for="monthlyReport">Monthly Report</label></div>';
        $html .= '<div class="mew"><input type="radio" id="dailyReport" name="filter_radio" value="dailyReport" ' . (($selected_radio == 'dailyReport') ? 'checked' : '') . '/><label for="dailyReport">Daily Report</label></div>';
        //monthly report
        $html .= '<div id="monthly_report_container" class="sbox" style="display:' . (($selected_radio == 'monthlyReport') ? 'block;' : 'none;') . '">';
        $html .= '<select id="monthName" name="monthName">';
        $html .= '<option value="all">All</option>';
        $current_month = date("Y/m/d", strtotime("+1 month", strtotime(date("Y/m/01"))));
        $init_month = $starting_month;
        while ($init_month != $current_month) {
            $display_month = date("F Y", strtotime($init_month));
            $option_value = date("Y-m", strtotime($init_month));
            $html .= '<option value="' . $option_value . '" ' . ($selectedMonth == $option_value ? 'selected' : '') . '>' . $display_month . '</option>';
            $init_month = date("Y/m/d", strtotime("+1 month", strtotime($init_month)));
        }
        $html .= '</select>';
        $html .= '</div>';
        //daily report
        $html .= '<div id="daily_report_container" class="sbox2" style="display:' . (($selected_radio == 'dailyReport') ? 'block;' : 'none;') . '">';
        if ($start_date == '' && $end_date == '') {
            $start_date = date('Y/m/01');
            $end_date = date("Y/m/d", strtotime("-1 day", strtotime("+1 month", strtotime(date('Y/m/01')))));
        }
        $html .= '<label for="startDate">Start Date</label><input type="text" class="datePicker spinput" id="startDate" name="startDate" value="' . $start_date . '" />';
        $html .= '<label for="endDate">End Date</label><input type="text" class="datePicker spinput" id="endDate" name="endDate" value="' . $end_date . '" />';
        $html .= '</div>';
        if (($CI->uri->segment(2) !== 'dayMonthSumReport' ) && ($CI->uri->segment(2) != "logintracking" ) && ($CI->uri->segment(2) != "unauthorized" ) && ($CI->uri->segment(2) != "DirectFlyUpBenefitHistory" ) && ($CI->uri->segment(2) != "loginhistory" ) && ($CI->uri->segment(2) != "businessLine" ) && ($CI->uri->segment(2) != "viewAllTeam" )) {
            $html .= '<div  class="childkey"><label for="ccode" id="ccode" >'.(($CI->uri->segment(2) == 'salesHistory') ? 'Registered By Code' 
                    : (($CI->uri->segment(2) == 'directHistory') ? 'Introducer Code'
                    : (($CI->uri->segment(2) == 'flyUpHistory') ? 'Fly UP Benefit To Code'
                    :  (($CI->uri->segment(2) == 'auditLog') ? 'Distributor Code'
                    :  (( $CI->uri->segment(2) == 'transferHistory' )? 'Transfer BY Code'
                    :  (( $CI->uri->segment(2) == 'admintransferhistory' )? 'Transfer To Code'
                    :  (( $CI->uri->segment(2) == 'distributorReport' )? 'Distributor Code'
                    :  (( $CI->uri->segment(2) == 'productHistory' )? 'Distributor Code'
                    :  (( $CI->uri->segment(2) == 'adminbalancehistory' )? 'Distributor Code'
                    : 'Code' ))))))))).
                    '</label><input type="text" name="code" id ="code" class="spinput" value="'.($CI->input->get('code') ? $CI->input->get('code') : '').'"></div>';
        }   
                 if($CI->uri->segment(2) == 'distributorReport'){
          $html .=   '<div  class="childkey"><label for="cname" id="cname" >Distributor Name</label><input type="text" name="name" id ="name" class="spinput" value="'.($CI->input->get('name') ? $CI->input->get('name') : '').'"></div>';
        }
        if($CI->uri->segment(2) == 'productHistory'){
          $html .=   '<div  class="childkey">
              <select name="paidUnpaid" id="paidUnpaid">
                  <option value="All"' . ($CI->input->get('paidUnpaid') == 2 ? 'selected' : '') .'>All</option>
              <option value="Paid"' . ($CI->input->get('paidUnpaid') == 1 ? 'selected' : '') .'>Paid</option>
              <option value="UnPaid"' . ($CI->input->get('paidUnpaid') == 3 ? 'selected' : '') .'>UnPaid</option>
              </select></div>';
        }
        if($CI->uri->segment(2) == 'adminbalancehistory'){
          $html .=   '<div  class="childkey"><label for="cname" id="cname" >Paid & Un-Paid</label>
              <select name="paidUnpaid" id="paidUnpaid">
                  <option></option>
              <option value="Paid"' . ($CI->input->get('paidUnpaid') == 1 ? 'selected' : '') .'>Paid</option>
              <option value="UnPaid"' . ($CI->input->get('paidUnpaid') == 3 ? 'selected' : '') .'>UnPaid</option>
              </select></div>';
        }
        $html .= '<input type="submit" class="btn btn-primary" value ="Search">';
        $html .= '</form>';


        //script
        return $html;
    }
    if (!function_exists('convertTri')) {

        function convertTri($num,$tri) {
            $ones = array("", " one", " two", " three", " four", " five", " six", " seven", " eight", " nine", " ten", " eleven", " twelve", " thirteen", " fourteen", " fifteen", " sixteen", " seventeen", " eighteen", " nineteen");
            $tens = array("", "", " twenty", " thirty", " forty", " fifty", " sixty", " seventy", " eighty", " ninety");
            $triplets = array("", " thousand", " million", " billion", " trillion", " quadrillion", " quintillion", " sextillion", " septillion", " octillion", " nonillion");
            // chunk the number, ...rxyy
            $r = (int) ($num / 1000);
            $x = ($num / 100) % 10;
            $y = $num % 100;

            // init the output string
            $str = "";

            // do hundreds
            if ($x > 0)
                $str = $ones[$x] . " hundred";

            // do ones and tens
            if ($y < 20)
                $str .= $ones[$y];
            else
                $str .= $tens[(int) ($y / 10)] . $ones[$y % 10];

            // add triplet modifier only if there
            // is some output to be modified...
            if ($str != "")
                $str .= $triplets[$tri];

            // continue recursing?
            if ($r > 0)
                return convertTri($r, $tri + 1) . $str;
            else
                return $str;
        }

    }
    if (!function_exists('getinwords')) {
    function convertNum($num) {
        $num = (int) $num;    // make sure it's an integer

        if ($num < 0)
            return "negative" . convertTri(-$num, 0);

        if ($num == 0)
            return "zero";

        return convertTri($num, 0);
    }
    }
}

/* End of file email_helper.php */
/* Location: ./system/helpers/email_helper.php */