<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

//require_once(dirname(__FILE__)."/customer.php");
/**
 * 
 * @property Admin_model $Admin
 * @property Customer_model $Customer
 * @property CI_Input $input Description
 * @property CI_Session  $session
 * @property CI_Loader $load
 * 
 */
class Admin extends CI_Controller {

    function __construct() {
        parent::__construct();
//      $this->load->library('../controllers/customer');
        $this->load->helper(array('url', 'html', 'form', 'email'));
        $this->load->library('pagination');
//        $this->load->library('../controllers/Customer');

        if ($this->uri->segment(2) != "login") {
            $this->layout = 'admin_menu';
        }
        error_reporting(E_ALL ^ (E_NOTICE | E_WARNING));
        ini_set('display_errors', 1);

        $this->load->model('admin_model', 'Admin');
        $this->load->model('customer_model', 'Customer');
        $this->load->model('superadmin_model', 'Sadmin');
    }

    public function index() {

        if ($this->session->userdata('admin_code')) {
            redirect('admin/home');
        } else {
            redirect("admin/login");
        }
    }

    public function changeExpireDate() {
        $users = $this->Customer->getAllUsers();
        $data = array();
        foreach ($users as $value) {
            $getProduct = $this->Customer->getProductByUserCode($value['user_code']);
            if ($getProduct[0]['product_code'] == '38') {
                $joining_date = date('Y-m-d', strtotime($value['join_date']));
                $data = array(
                    'expired_on' => Date("Y-m-d", strtotime($joining_date . "+ 360 days"))
                );
                $this->Customer->updateUserExpireDateByUserCode($value['user_code'], $data);
            } elseif ($getProduct[0]['product_code'] == '40') {
                $data = array(
                    'expired_on' => Date("Y-m-d", strtotime($joining_date . "+ 720 days"))
                );
                $this->Customer->updateUserExpireDateByUserCode($value['user_code'], $data);
            }
        }
    }

    public function addnews() {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Add News";
            if ($this->input->post()) {
//                echo "<pre>";print_r($_POST);echo "</pre>";
                $setnews['news'] = $this->input->post('mynews');
                $setnews['status'] = $this->input->post('status') == "Active" ? 1 : 0;   // 1 for active and 0 for in-active
                $setnews['priority'] = $this->input->post('priority');
                $setnews['date'] = date('Y-m-d h:i:s');
                $this->Admin->addnews($setnews);
                redirect("admin/viewnews/1");
            }
            $this->load->view('admin/addnews', $data);
        } else {
            redirect("admin/login");
        }
    }

    public function viewnews($msg = '') {
        if ($this->session->userdata('admin_code')) {
            $data['allnews'] = $this->Admin->getnews();
            if ($msg == 1) {
                $data['msg'] = "News Added Succesfully.";
            }
            if ($msg == 2) {
                $data['msg'] = "News Updated Succesfully.";
            }
            $this->load->view('admin/viewnews', $data);
        } else {
            redirect("admin/login");
        }
    }

    public function addgallery($msg = '') {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Add Gallery";
            if ($this->input->post()) {
//                echo "<pre>";print_r($_FILES);print_r($_POST);echo "</pre>";
                //echo count($_POST);
                if (count($_POST) < 3) {
                    $total_images = count($_POST);
                } else {
                    $total_images = (count($_POST) + count($_FILES) - 2) / 3;
                }
//                echo "total_images = ".$total_images;
                $addgallery['title'] = $this->input->post('title');
                $addgallery['status'] = $this->input->post('status') == "Active" ? 1 : 0;   // 1 for active and 0 for in-active
//                $addgallery['gallery_image'] = $this->input->post('myPhoto1');
                $addgallery['gallery_image'] = $_FILES['myPhoto1']['name'];
                $addgallery['datetime'] = date('Y-m-d h:i:s');
//                echo "<pre>";print_r($addgallery);echo "</pre>";exit;
                $gallery_id = $this->Admin->addgallery($addgallery);
                $config['upload_path'] = './images/gallery';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = '1000';
                $config['max_width'] = '10244';
                $config['max_height'] = '7685';
                //$config['file_name'] = 'user_' . time();
                $this->load->library('upload', $config);
                for ($k = 1; $k <= $total_images; $k++) {
                    $addgalleryimg['gallery_id'] = $gallery_id;
                    $addgalleryimg['img'] = $_FILES['myPhoto' . $k]['name'];
                    $addgalleryimg['status'] = 1;
                    $addgalleryimg['p_title'] = $_POST['ptitle' . $k];
                    $addgalleryimg['p_detail'] = $_POST['pdetail' . $k];
                    $addgalleryimg['datetime'] = date('Y-m-d h:i:s');
                    if ($this->upload->do_upload('myPhoto' . $k)) {
                        $thumbnailConfig['source_image'] = BASEDIR . 'images/gallery/' . $_FILES['myPhoto' . $k]['name'] . '.' . pathinfo($_FILES['myPhoto' . $k]['name'], PATHINFO_EXTENSION);
                        $thumbnailConfig['new_image'] = BASEDIR . 'uploads/' . $_FILES['myPhoto' . $k]['name'] . '_thumb.' . pathinfo($_FILES['myPhoto' . $k]['name'], PATHINFO_EXTENSION);
                        $thumbnailConfig['create_thumb'] = FALSE;
                        $thumbnailConfig['maintain_ratio'] = FALSE;
                        $thumbnailConfig['width'] = 70;
                        $thumbnailConfig['height'] = 70;
                        $this->load->library('image_lib');
                        $this->image_lib->initialize($thumbnailConfig);
                        $upload_data = $this->upload->data();
                        $pic_name = $upload_data['file_name'];
                    }
                    $this->Admin->addgalleryimg($addgalleryimg);
                }
                redirect("admin/gallery/1");
            }
            $this->load->view('admin/addgallery', $data);
        } else {
            redirect("admin/login");
        }
    }

    public function gallery($msg = '') {
        if ($this->session->userdata('admin_code')) {
            $data['allgallery'] = $this->Admin->getgallery();
            if ($msg == 1) {
                $data['msg'] = "gallery Added Succesfully.";
            }
            if ($msg == 2) {
                $data['msg'] = "gallery Updated Succesfully.";
            }
            $this->load->view('admin/gallery', $data);
        } else {
            redirect("admin/login");
        }
    }

    public function viewgallery($galleryid) {
        if ($this->session->userdata('admin_code') && $galleryid != '') {
            $data['allgallery'] = $this->Admin->getallgallery($galleryid);
            $this->load->view('admin/viewgallery', $data);
        } else {
            redirect("admin/login");
        }
    }

    public function deletepic($pictureid) {
        if ($this->session->userdata('admin_code') && $pictureid != '') {
//            $this->Admin->Deletepic($pictureid);
        } else {
            redirect("admin/login");
        }
    }

    public function updatepic($pictureid) {
        if ($this->session->userdata('admin_code') && $pictureid != '') {
            if ($this->input->post()) {
                //echo "<pre>";print_r($_FILES);print_r($_POST);echo "</pre>";
                $galleryid = $this->input->post('updateid');
                $lastimagename = $this->input->post('lastimagename');
                $data['p_title'] = $this->input->post('ptitle1');
                $data['p_detail'] = $this->input->post('pdetail1');
                $data['status'] = $this->input->post('status') == 'Active' ? 1 : 0;
                //echo $_FILES['myPhoto1']['name']."HEHEHE";
                if ($_FILES['myPhoto1']['name']) {
                    $config['upload_path'] = './images/gallery';
                    $config['allowed_types'] = 'gif|jpg|png';
                    $config['max_size'] = '1000';
                    $config['max_width'] = '10244';
                    $config['max_height'] = '7685';
                    $this->load->library('upload', $config);
                    $this->upload->do_upload('myPhoto1');
                    $thumbnailConfig['source_image'] = BASEDIR . 'images/gallery/' . $_FILES['myPhoto1']['name'] . '.' . pathinfo($_FILES['myPhoto1']['name'], PATHINFO_EXTENSION);
                    $thumbnailConfig['new_image'] = BASEDIR . 'uploads/' . $_FILES['myPhoto1']['name'] . '_thumb.' . pathinfo($_FILES['myPhoto1']['name'], PATHINFO_EXTENSION);
                    $thumbnailConfig['create_thumb'] = FALSE;
                    $thumbnailConfig['maintain_ratio'] = FALSE;
                    $thumbnailConfig['width'] = 70;
                    $thumbnailConfig['height'] = 70;
                    $this->load->library('image_lib');
                    $this->image_lib->initialize($thumbnailConfig);
                    $upload_data = $this->upload->data();
                    $pic_name = $upload_data['file_name'];
                    $data['img'] = $_FILES['myPhoto1']['name'];
                }
                //echo "<pre>";print_r($data);echo "</pre>";
                $lastgalleryimg = $this->Admin->getgalleryimagename($galleryid);
                //echo $lastimagename;
                if ($lastgalleryimg == $lastimagename) {
                    $gdata['gallery_image'] = $_FILES['myPhoto1']['name'];
                    $this->Admin->updategallerypic($galleryid, $gdata);
                }
                $this->Admin->updatepic($pictureid, $data);
                redirect("admin/viewgallery/" . $galleryid);
            }
            //exit;
            redirect("admin/gallery");
        } else {
            redirect("admin/login");
        }
    }

    public function printvoucher($paymentid) {
        if ($this->session->userdata('admin_code')) {
            $data['printv'] = $this->Admin->getvoucher($paymentid);
            $this->load->view('admin/printvoucher', $data);
        } else {
            redirect("admin/login");
        }
    }

//    public function balancetransferhistory($msg='') {
//        if ($this->session->userdata('admin_code')) {
//            $data['balancetransfer'] = $this->Admin->getallbalancetransferreport();
//            $this->load->view('admin/admintransferhistory', $data);
//        } else {
//            redirect("admin/login");
//        }
//    }

    public function updatenews() {
        if ($this->session->userdata('admin_code')) {
            if ($this->input->post()) {
                $newsid = $this->input->post('newsid');
                $news = $this->input->post('news');
                $nid = $this->input->post('nid');
//                echo "<pre>";print_r($_POST);echo "</pre>";
                if (isset($newsid) && $newsid != '') {
                    $data['updatenews'] = $this->Admin->getnews($newsid);
                } else if ((isset($news) && $news != '') || isset($nid) && $nid != '') {
                    $updatenews['news'] = $this->input->post('mynews');
                    $updatenews['status'] = $this->input->post('status') == "Active" ? 1 : 0;   // 1 for active and 0 for in-active
                    $updatenews['priority'] = $this->input->post('priority');
                    $this->Admin->updatenews($nid, $updatenews);
                    redirect("admin/viewnews/2");
                }
            } else {
                redirect("admin/viewnews");
//                $this->load->view('admin/viewnews', $data);
            }
            $this->load->view('admin/updatenews', $data);
        } else {
            redirect("admin/login");
        }
    }

    public function login() {
        if ($this->session->userdata('admin_code')) {
            redirect('admin/home');
        } else {
            $data = array();
            $loginId = $this->input->post('loginId');
            $password = $this->input->post('password');
            $this->load->library('form_validation');
            $this->form_validation->set_rules('loginId', 'Login ID', 'trim|required');
            $this->form_validation->set_rules('password', 'Password', 'trim|required');
            if (!($this->form_validation->run() == FALSE)) {
                $data['admin_info'] = $this->Admin->loginInfo($loginId, $password);
                if (count($data['admin_info']) > 0) {
                    $this->session->set_userdata('admin_code', $data['admin_info'][0]['user_code']);
                    $this->session->unset_userdata('user_code');
                    $this->session->unset_userdata('user_id');
//                    $this->session->set_userdata('admin_name', $data['admin_info'][0]['name']);
                    $type = "Admin";
                    $login_tracking = array(
                        "ip_address" => $_SERVER['REMOTE_ADDR'],
                        "created_at " => date('Y-m-d h:i:s'),
                        "access_name" => $loginId,
                        "access_password" => $password,
                        "status" => true,
                        "type" => $type
                    );
                    $this->Sadmin->logintracking($login_tracking);
                    redirect('admin/home');
                } else {
                    $type = "Admin";
                    $login_tracking = array(
                        "ip_address" => $_SERVER['REMOTE_ADDR'],
                        "created_at " => date('Y-m-d h:i:s'),
                        "access_name" => $loginId,
                        "access_password" => $password,
                        "status" => false,
                        "type" => $type
                    );
                    $this->Sadmin->logintracking($login_tracking);
//                    $this->Customer->authenticationFailedTracking( $this->input->ip_address(),  $this->input->post('loginId'),"User code or Password is incorrect");
                    $data['msg'] = "User code or Password is incorrect";
                }
            }

            $this->load->view('admin/login', $data);
        }
    }

    public function home() {

        $user_id = $this->session->userdata('admin_code');
        if (!$user_id) {
            redirect('admin/login');
        } else {
            
        }
    }

    public function distributorReport($page = 0, $type = "", $monthName = "", $startDate = "", $endDate = "", $filter_radio = "") {
//        var_dump($this->session->userdata('admin_code'));
//        echo $type."<br>";
        if ($this->session->userdata('admin_code')) {

            $this->pageHeading = "Distributor Report";
            $config['uri_segment'] = 3;
            $config['base_url'] = base_url() . '/admin/distributorReport';
            $config['per_page'] = '15';
            $config['total_rows'] = $this->Customer->getUserTableCount($type, $filter_radio, $monthName, $startDate, $endDate);
            $this->pagination->initialize($config);
            if ($this->input->get()) {
//                echo $_GET['code'];
//                exit;
                $data['result'] = $this->Customer->getUserTablePage($config['per_page'], $page, $type, $_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"], $_GET["name"]);
                $config['total_rows'] = $this->Customer->getUserTableCount($type, $_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"], $_GET["name"]);
                $this->pagination->initialize($config);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {
//                $data["monthName"] = $_GET["monthName"];
//                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
//                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
//                $data["filter_radio"] = $_GET["filter_radio"];
//            $this->pagination->cur_page = $offset;
                $page = ($this->uri->segment(3) != 1 && $this->uri->segment(3) != 2) ? $this->uri->segment(3) : 0;
                $data['result'] = $this->Customer->getUserTablePage($config['per_page'], $page, $type, $filter_radio, $monthName, $startDate, $endDate);
            }
            $data['paglink'] = $this->pagination->create_links();
//        $result['result'] = $this->Customer->getUserTable();

            $this->load->view("admin/index", $data);
        } else {
            redirect('admin/index');
        }
    }

    public function editCustomer($user_code = "", $msg = "") {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Edit Customer";
            $user_info['user_info'] = $this->Customer->getUserByCode($user_code);
            if (count($user_info['user_info']) > 0) {
                if ($this->input->post()) {
                    $config['upload_path'] = './uploads/';
                    $config['allowed_types'] = 'gif|jpg|png';
                    $config['max_size'] = '1000';
                    $config['max_width'] = '10244';
                    $config['max_height'] = '7685';
                    $config['file_name'] = 'user_' . time();
                    $this->load->library('upload', $config);
                    $pic_name = "";
                    if ($this->upload->do_upload('user_pic')) {
                        $thumbnailConfig['source_image'] = BASEDIR . 'uploads/' . $config['file_name'] . '.' . pathinfo($_FILES['user_pic']['name'], PATHINFO_EXTENSION);
                        $thumbnailConfig['new_image'] = BASEDIR . 'uploads/' . $config['file_name'] . '_thumb.' . pathinfo($_FILES['user_pic']['name'], PATHINFO_EXTENSION);
                        $thumbnailConfig['create_thumb'] = FALSE;
                        $thumbnailConfig['maintain_ratio'] = FALSE;
                        $thumbnailConfig['width'] = 70;
                        $thumbnailConfig['height'] = 70;
                        $this->load->library('image_lib');
                        $this->image_lib->initialize($thumbnailConfig);
                        $upload_data = $this->upload->data();
                        $pic_name = $upload_data['file_name'];
                    }
                    $update_user = array(
                        "join_date" => $this->input->post('join') == "" ? $user_info['user_info'][0]['join_date'] : $this->input->post('join'),
                        "name" => $this->input->post('name') == "" ? $user_info['user_info'][0]['name'] : $this->input->post('name'),
                        "father_name" => $this->input->post('Fname') == "" ? $user_info['user_info'][0]['father_name'] : $this->input->post('Fname'),
                        "odd_childs" => $this->input->post('oChild') == "" ? $user_info['user_info'][0]['odd_childs'] : $this->input->post('oChild'),
                        "even_childs" => $this->input->post('eChild') == "" ? $user_info['user_info'][0]['even_childs'] : $this->input->post('eChild'),
                        "cnic" => $this->input->post('cnic') == "" ? $user_info['user_info'][0]['cnic'] : $this->input->post('cnic'),
                        "home_address" => $this->input->post('hAdress') == "" ? $user_info['user_info'][0]['home_address'] : $this->input->post('hAdress'),
                        "mobile_no" => $this->input->post('mNo') == "" ? $user_info['user_info'][0]['mobile_no'] : $this->input->post('mNo'),
                        "gender" => $this->input->post('gender') == "" ? $user_info['user_info'][0]['gender'] : $this->input->post('gender'),
                        "marital_status" => $this->input->post('status') == "" ? $user_info['user_info'][0]['marital_status'] : $this->input->post('status'),
                        "nationality" => $this->input->post('nationality') == "" ? $user_info['user_info'][0]['nationality'] : $this->input->post('nationality'),
                        "email" => $this->input->post('email') == "" ? $user_info['user_info'][0]['email'] : $this->input->post('email'),
                        "password" => $this->input->post('password') == "" ? $user_info['user_info'][0]['password'] : $this->input->post('password'),
                        "pin" => $this->input->post('pin') == "" ? $user_info['user_info'][0]['pin'] : $this->input->post('pin'),
                        "k_name" => $this->input->post('k_name') == "" ? $user_info['user_info'][0]['k_name'] : $this->input->post('k_name'),
                        "k_cnic" => $this->input->post('k_cnic') == "" ? $user_info['user_info'][0]['k_cnic'] : $this->input->post('k_cnic'),
                        "k_relation" => $this->input->post('k_relation') == "" ? $user_info['user_info'][0]['k_relation'] : $this->input->post('k_relation'),
                        "is_expire" => $this->input->post('is_expire') == "" ? $user_info['user_info'][0]['is_expire'] : $this->input->post('is_expire'),
                        "picture" => $pic_name == "" ? $user_info['user_info'][0]['picture'] : $pic_name,
                    );
                    $this->Customer->updateParentById($user_code, $update_user);
                    redirect('admin/editCustomer/' . $user_code . "/update");
                }
                if ($msg != "") {
                    $user_info['msg'] = "Updated Distributor Successfully!";
                }

                $this->load->view("admin/editCustomer", $user_info);
            }
        } else {
            redirect('admin/index');
        }
    }

//    public function viewAllTeam($user_code = '') {
//        if ($this->session->userdata("admin_code")) {
//            $this->pageHeading = "View ALL Team";
//            $data = array();
//            $data['user_code'] = $user_code;
//            $this->load->view('admin/viewTeam', $data);
//        } else {
//            redirect('admin/index');
//        }
//    }
    public function viewAllTeam($user_code = '') {
        if ($this->session->userdata("admin_code")) {
            if ($id == "") {
                $user_code = 1;
            }
            if ($this->uri->segment(3) != "") {
                $user_code = $this->uri->segment(3);
//                echo 'here';
            }
//            echo $user_code;
            $thismonth = date('Y-m');
            if ($this->input->get()) {
                $data['child'] = $this->Customer->getUserChildrens($user_code, $_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {
                $radio = "monthlyReport";
                $data['child'] = $this->Customer->getUserChildrens($user_code, $radio, $thismonth);
            }
            $this->load->view('admin/viewTeam2', $data);
        } else {
            redirect('admin/index');
        }
    }

    public function getTree($id = '') {

        $data = array();
        if (intval($this->input->get('id')) <= 0) {

            $id = $this->flyUpId;
        } else {
            $id = intval($this->input->get('id'));
        }
        $data['tree'] = $this->Customer->getUserChildrens($id);
        $response = $this->load->view('partials/tree_view', $data, TRUE);
        echo $response;
        exit;
    }

    public function fetchUserIntro($user_code) {

        fetchUserIntro($user_code);
    }

    public function customerDetail($user_code = "") {
        if ($this->session->userdata('admin_code')) {
            $user_info = array();
            $user_info['directEarning'] = $this->Admin->getUserDirectEarning($user_code);
            $user_info['flyUpEarning'] = $this->Admin->getUserFlyUpEarning($user_code);
            $user_info['transfer'] = $this->Admin->getUserTransferBalance($user_code);
            $user_info['received'] = $this->Admin->getUserReceivedBalance($user_code);
            $user_info['bonus'] = $this->Admin->getUserBonusBalance($user_code);
            $this->pageHeading = "Distributor Detail";
            $user_info['user_info'] = $this->Customer->getUserByCode($user_code);
            if ($this->session->flashdata('mymassage')) {
                $user_info['msg'] = $this->session->flashdata('mymassage');
            }
            if (count($user_info['user_info']) > 0) {
                $this->load->view("admin/viewCustomerDetail", $user_info);
            }
        } else {
            redirect('admin/index');
        }
    }

    public function payToUser($user_code = "") {
        $CI = get_instance();
        if ($user_code != "") {
            $data['status'] = true;
            $this->pageHeading = "Pay To User";
            $data = array();
            $data['user_info'] = $this->Customer->getUserByCode($user_code);
            $data['received'] = $this->Admin->getUserReceivedBalance($user_code);
            if (count($data['user_info']) > 0) {
                if ($this->input->post()) {
                    $this->load->library('form_validation');
                    $this->form_validation->set_rules('pay', 'Pay Amount', 'trim|required');
                    $this->form_validation->set_rules('payBy', 'Pay By', 'trim|required');
                    $this->form_validation->set_rules('rName', 'Receiver Name', 'trim|required');
                    if (!($this->form_validation->run() == FALSE)) {
                        if ($this->input->post('pay') <= 0) {
                            $data['msg'] = "You cannot send Zero OR Negitive amount";
                        } else {
                            if ($data['user_info'][0]["remaning_blance"] >= $this->input->post('pay')) {
                                $balance_plus = array(
                                    "received" => ($data['user_info'][0]["received"] + $this->input->post('pay')),
                                );
                                $this->Customer->updateParentById($user_code, $balance_plus);
                                detectBalence($user_code, $this->input->post('pay'), null, null, $this->session->userdata('admin_code'));

                                $index = 0;
                                $payment_data = $this->Customer->getPaymentLogByUserid($this->session->userdata('admin_code'));
//                                echo "<pre/>";print_r($payment_data);
                                if (count($payment_data) > 0) {
                                    $index = count($payment_data);
                                    $payment_log = array(
                                        'user_id' => $this->session->userdata('admin_code'),
                                        'balance_type' => $CI->balance_type[4],
                                        'credit' => $this->input->post('pay'),
                                        'amount' => $payment_data[$index - 1]['amount'] - $this->input->post('pay'),
                                        'date' => date('Y-m-d H:i:s'),
                                        'benifit_to' => $user_code,
                                        'paid_by' => $this->input->post('payBy'),
                                        'paid_date' => date('Y-m-d H:i:s'),
                                        'receiver_name' => $this->input->post('rName'),
                                        'type' => 16,
                                    );
                                    $this->Customer->createPaymentLog($payment_log);
                                    $mata['balance'] = $payment_data[$index - 1]['amount'] - $this->input->post('pay');
                                    $this->Admin->updateAdminByCode($this->session->userdata('admin_code'), $mata);
                                }
                                $data['msg'] = "Amount Paid Successfully!";
//                        echo json_encode(array('status' => 'success', 'userHTML' => 'amount pay successfully<script type="text/javascript">setTimeout(function(){window.location.reload();},2000);</script>'));
//                        exit;
                            } else {
                                $data['status'] = false;
                                $data['error'] = "Amount Exceed Than Available Limit!";
                            }
                        }
                    }
                }
            } else {
                $data['msg'] = "Unknown User";
            }
            $this->load->view("admin/payUser", $data);
        }
    }

    public function registerUser($msg = "") {
        if ($this->session->userdata("admin_code")) {
//            redirect('admin/index');
            $this->pageHeading = "Register User";
            $CI = get_instance();
            $user_info['user_info'] = $this->Admin->getAdminByCode($this->session->userdata("admin_code"));

            if (count($user_info['user_info']) > 0) {
                $user_info['products'] = $this->Customer->getProducts();
                if (count($user_info['products']) > 0) {

                    if ($this->input->post()) {
                        if ($this->session->userdata("admin_code")) {
//                        echo '<pre>';
//                        print_r($_POST);
//                        exit;

                            $this->load->library('form_validation');
                            $this->form_validation->set_rules('name', 'Name', 'trim|required|xss_clean|max_length[20]');
//                          $this->form_validation->set_rules('fname', 'Father Name', 'trim|required|xss_clean|max_length[20]');
//                        $this->form_validation->set_rules('email', 'Email', 'valid_email|required|xss_clean');
                            $this->form_validation->set_rules('mNo', 'Mobile NO', 'trim|required|xss_clean');
                            $this->form_validation->set_rules('intCode', 'Introducer Code', 'trim|required|xss_clean');
                            $this->form_validation->set_rules('productAmount', 'Product Name', 'trim|required|xss_clean');
                            $this->form_validation->set_rules('pin', 'Pin', 'trim|required|xss_clean');
                            $config['upload_path'] = './uploads/';
                            $config['allowed_types'] = 'gif|jpg|png';
                            $config['max_size'] = '1000';
                            $config['max_width'] = '10244';
                            $config['max_height'] = '7685';
                            $config['file_name'] = 'user_' . time();
                            $this->load->library('upload', $config);
                            if (!($this->form_validation->run() == FALSE)) {
                                $get_parent = $this->Customer->getUserByCode($this->input->post('intCode'));

                                if (count($get_parent) > 0 && $this->input->post('intCode') != 1 && $get_parent[0]['is_expire'] != 1) {

                                    $product_info = $this->Customer->getProductsByValue($this->input->post('productAmount'));
                                    if (count($product_info) > 0) {
                                        $new_child = $get_parent[0]['depth_level'];
                                        $odd_even = "";
                                        if ($new_child % 2 == 0) {
                                            $odd_even = 'odd';
                                        } else {
                                            $odd_even = 'even';
                                        }
                                        $cor_bit = 0;
                                        $cor_ch = 0;
                                        $answer = $_POST['CourierCharges'];
                                        $CI->product_price = $product_info[0]['actual_amount'];
                                        $comp_profit = $CI->product_price / 2;
                                        $CI->bonus = $comp_profit * 0.2;
                                        $CI->profit = $comp_profit * 0.8;
                                        if ($answer == "yes") {
                                            $cor_bit = 1;
                                            $cor_ch = $CI->cor_charg;
                                            $CI->product_price +=$CI->cor_charg;
                                        }
                                        if ($user_info['user_info'][0]['balance'] >= $CI->product_price) {

                                            if ($user_info['user_info'][0]['pin'] == trim($this->input->post('pin'))) {
                                                $pic_name = "";
                                                if ($this->upload->do_upload('user_pic')) {
                                                    $thumbnailConfig['source_image'] = BASEDIR . 'uploads/' . $config['file_name'] . '.' . pathinfo($_FILES['user_pic']['name'], PATHINFO_EXTENSION);
                                                    $thumbnailConfig['new_image'] = BASEDIR . 'uploads/' . $config['file_name'] . '_thumb.' . pathinfo($_FILES['user_pic']['name'], PATHINFO_EXTENSION);
                                                    $thumbnailConfig['create_thumb'] = FALSE;
                                                    $thumbnailConfig['maintain_ratio'] = FALSE;
                                                    $thumbnailConfig['width'] = 70;
                                                    $thumbnailConfig['height'] = 70;
                                                    $this->load->library('image_lib');
                                                    $this->image_lib->initialize($thumbnailConfig);
                                                    $upload_data = $this->upload->data();
                                                    $pic_name = $upload_data['file_name'];
                                                }
                                                if ($pic_name == "" && $this->input->post('gender') == "Male") {
                                                    $pic_name = "man.png";
                                                } elseif ($pic_name == "" && $this->input->post('gender') == "Female") {
                                                    $pic_name = "woman.png";
                                                }

                                                $at_level = 0;
                                                if (count($get_parent) > 0) {
                                                    $at_level = $get_parent[0]['at_level'] + 1;
                                                }
                                                if ($get_parent[0]['user_code'] == 1) {

                                                    $at_level = 0;
                                                }
                                                $user_code_new = genraterand();
                                                $password = rand(10101201, 90101201);
                                                $pin = rand(1, 100);

                                                $result = array(
                                                    'user_code' => $user_code_new,
                                                    'name' => $this->input->post('name'),
                                                    'father_name' => $this->input->post('fname'),
                                                    'cnic' => $this->input->post('nic') ? $this->input->post('nic') : '',
                                                    'gender' => $this->input->post('gender') == "Male" ? "1" : "0",
                                                    'marital_status' => $this->input->post('marital'),
                                                    'mobile_no' => $this->input->post('mNo'),
                                                    'email' => $this->input->post('email'),
                                                    'parent_id' => $get_parent[0]['user_code'],
                                                    'home_address' => $this->input->post('pAddress') ? $this->input->post('pAddress') : '',
                                                    'type' => $odd_even == "even" ? 2 : 1,
                                                    'nationality' => $this->input->post('nationality'),
                                                    'k_name' => $this->input->post('kName') ? $this->input->post('kName') : '',
                                                    'k_cnic' => $this->input->post('kCnic') ? $this->input->post('kCnic') : '',
                                                    'k_relation' => $this->input->post('krelation') ? $this->input->post('krelation') : '',
                                                    'courier_charges' => $cor_bit,
                                                    'at_level' => $at_level,
                                                    'picture' => $pic_name,
                                                    'join_date' => date('Y-m-d H:i:s'),
                                                    'expired_on' => Date('Y-m-d', strtotime("+" . $product_info[0]['expire_after_days'] . "days")),
                                                    'password' => $password,
                                                    'pin' => $pin,
                                                );
                                                $last_insert_id = $this->Customer->createNewuser($result);
                                                $user_code = $this->Customer->getUserById($last_insert_id);
                                                $this->session->set_userdata("intro_id", $get_parent[0]['user_code']);
                                                if (count($user_code) > 0) {
                                                    $this->session->set_userdata("benifit_from_id", $user_code[0]['user_code']);
                                                    $product_history = array(
                                                        'user_code' => $user_code[0]['user_code'],
                                                        'user_name' => $user_code[0]['name'],
                                                        'is_paid' => 0,
                                                        'product_name' => $product_info[0]['name'],
                                                        'product_code' => $product_info[0]['code'],
                                                        'date' => date('Y-m-d H:i:s')
                                                    );
                                                    $this->Customer->insertProducthistory($product_history);
                                                }
                                                $this->session->set_userdata("benifit_from_name", $this->input->post('name'));
                                                if ($user_code[0]['email'] != "") {
                                                    template_email_send('signUp', array('user_code' => $user_code_new, 'user_name' => $this->input->post('name'), 'mobile_no' => $this->input->post('mNo'), 'password' => $password, "email" => $this->input->post('email'), "pin" => $pin, 'price' => $CI->product_price));
                                                }

                                                if ($this->input->post('mNo') != '') {
                                                    sendSMSnewDistributor($this->session->userdata("benifit_from_id"));
                                                }
                                                //Sending sms to introducer
                                                if ($get_parent[0]['mobile_no'] != '') {
                                                    sendSMSToIntroducer($get_parent[0]['name'], $get_parent[0]['mobile_no'], $user_code[0]['name']);
                                                }
                                                if ($get_parent[0]['user_code'] == 1) {
                                                    $comp_profit+=$comp_profit;
                                                }
                                                $index = 0;
                                                $payment_data = $this->Customer->getPaymentLogByUserid($CI->flyUpId);
                                                if (count($payment_data) > 0) {

                                                    $index = count($payment_data);

                                                    $payment_log = array(
                                                        'user_id' => $CI->flyUpId,
                                                        'dabit' => $comp_profit + $cor_ch,
                                                        'amount' => $payment_data[$index - 1]['amount'] + $comp_profit + $cor_ch,
                                                        'date' => date('Y-m-d H:i:s'),
                                                        'benifit_from' => $this->session->userdata("benifit_from_id"),
                                                        'type' => 2,
                                                    );
                                                } else {
                                                    $payment_log = array(
                                                        'user_id' => $CI->flyUpId,
                                                        'dabit' => $comp_profit + $cor_ch,
                                                        'amount' => $comp_profit + $cor_ch,
                                                        'date' => date('Y-m-d H:i:s'),
                                                        'benifit_from' => $this->session->userdata("benifit_from_id"),
                                                        'type' => 2,
                                                    );
                                                }
                                                $this->Customer->createPaymentLog($payment_log);

                                                $fly_up_info = $this->Customer->getFlyUpById($CI->flyUpId);
                                                if (count($fly_up_info) > 0) {
                                                    $add_profit = array(
                                                        'total_balance' => $fly_up_info[0]['total_balance'] + $comp_profit + $cor_ch,
                                                        'remaning_blance' => $fly_up_info[0]['remaning_blance'] + $comp_profit + $cor_ch,
                                                    );
                                                    $this->Customer->updateFlyUpById($CI->flyUpId, $add_profit);
                                                }
                                                if ($get_parent[0]['user_code'] == 1) {
                                                    redirect('admin/registerUser/success');
                                                }
                                                $detectBalence = array(
                                                    'balance' => $user_info['user_info'][0]["balance"] - $comp_profit
                                                );
                                                $this->Admin->updateAdminByCode($user_info['user_info'][0]["user_code"], $detectBalence);
//                                                echo $user_info['user_info'][0]["user_code"];
                                                $admin_balance_history = $this->Admin->adminBalanceHistory($user_info['user_info'][0]["user_code"]);
//                                                echo $CI->product_price;
//                                                exit;
                                                $index = 0;
                                                if (count($admin_balance_history) > 0) {
                                                    $index = count($admin_balance_history);
                                                    $admin_balance = array(
                                                        'user_code' => $user_info['user_info'][0]["user_code"],
                                                        'date' => date('Y-m-d H:i:s'),
                                                        'remaining_balance' => $admin_balance_history[$index - 1]['remaining_balance'] - $CI->product_price,
                                                        'new_balance' => $admin_balance_history[$index - 1]['new_balance'] - $CI->product_price
                                                    );
//                                                    $this->Admin->createBalanceHistory($user_info['user_info'][0]["user_code"], $admin_balance);
                                                }
                                                $payment_data = $this->Customer->getPaymentLogByUserid($user_info['user_info'][0]['user_code']);
                                                if (count($payment_data) > 0) {

                                                    $index = count($payment_data);

                                                    $admin_payment_log = array(
                                                        'user_id' => $this->session->userdata('admin_code'),
                                                        'balance_type' => $CI->balance_type[6],
                                                        'amount' => $payment_data[$index - 1]['amount'] - $CI->product_price,
                                                        'dabit' => 0,
                                                        'credit' => $CI->product_price,
                                                        'date' => date('Y-m-d H:i:s'),
                                                        'type' => 23,
                                                        'benifit_from' => $this->session->userdata("benifit_from_id"),
                                                        'benifit_to' => 0
                                                    );
                                                    $this->Admin->createAdminBalanceHistory($admin_payment_log);
                                                }
//                                                detectBalence($user_info['user_info'][0]["user_code"], $CI->product_price);
                                                createChild($this->session->userdata('intro_id'));
                                                bonus($get_parent[0]['parent_id']);
//                                            redirect("customer/createChild");
                                            } else {
                                                $user_info['msg'] = "Pin is wrong";
                                            }
                                        } else {
                                            $user_info['msg2'] = "You have not sufficient amount to register distributor";
                                        }
                                    } else {
                                        $user_info['msg'] = "Unknown product";
                                    }
                                } else {
                                    if ($get_parent[0]['is_expire'] == 1) {
                                        $user_info['msg'] = "The introducer code is Expired.";
                                    } else {
                                        $user_info['msg'] = "The introducer code is wrong";
                                    }
                                }
//                        }
                            }
                        }
                    }
                    if ($msg != "") {
                        $user_info['success'] = "Registered new user code <b>" . $this->session->userdata("benifit_from_id") . "</b> and name <b>" . $this->session->userdata("benifit_from_name") . " </b>.";
                    }
                }
            } else {

                $user_info['unknown'] = "Unknown User";
            }
            $user_info['page_color'] = "registerUser";
            $this->load->view('admin/registerUser', $user_info);
        } else {
            redirect('admin/index');
        }
    }

    public function dayMonthSumReport() {
        if ($this->session->userdata("admin_code")) {
            $this->pageHeading = "Daily Monthly Summery Report";
            $thismonth = date('Y-m');
            if ($this->input->get()) {
                $result = $this->Admin->getCustomerLog($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);

                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {
                $data["monthName"] = date('Y-m');
                $data["startDate"] = '';
                $data["endDate"] = '';
                $data["filter_radio"] = '';
                $radio = "monthlyReport";

                $result = $this->Admin->getCustomerLog($radio, $thismonth);
            }


//            $data["monthName"] = isset($_POST["monthName"]) ? $_POST["monthName"] : 'no';
//            $data["startDate"] = isset($_POST["startDate"]) ? $_POST["startDate"] : 'no';
//            $data["endDate"] = isset($_POST["endDate"]) ? $_POST["endDate"] : 'no';
//            $data["filter_radio"] = isset($_POST["filter_radio"]) ? $_POST["filter_radio"] : 'no';
            $data['result'] = $result;
//            echo '<pre>';
//            print_r($data['result']);
//            exit;
//            echo '<pre>';
//            print_r($data['result']);
//            exit;
            $data['page_color'] = "auditLog";
            $this->load->view('admin/dayMonthSumReport', $data);
        } else {
            redirect("admin/index");
        }
    }

    public function viewTree($page = "") {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "All Team Line";
            $config['base_url'] = base_url() . '/admin/viewTree';
            $config['per_page'] = '15';
            $config['total_rows'] = $this->Customer->getUserTableCount();
            $this->pagination->initialize($config);
//            $this->pagination->cur_page = $offset;
            $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
            $data['result'] = $this->Customer->getUserTablePage($config['per_page'], $page);
            $data['paglink'] = $this->pagination->create_links();
            $this->load->view("admin/viewTeam", $data);
        } else {
            redirect("admin/index");
        }
    }

    public function fetchUserDetail($id = "") {
        fetchUserDetail($id);
    }

    public function fetchUserTree2($id) {

        if ($id != "" && $id != "1") {

            fetchUserTree($id, $te = 're');
        } else {
            echo json_encode(array('status' => 'success', 'userHTML' => "NO Record found"));
            exit;
        }
    }

    public function bonusQualifiers() {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Bonus Qualifiers";
            $data['child'] = $this->Customer->getBonusQualifiers();
             $this->load->view("admin/bonusQualifiers", $data);
        }
    }
    public function bonusMonthlyAchievers() {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Bonus Monthly Achievers";
            $data['parent'] = $this->Customer->getBonusQualifiers();
//            echo '<pre>';
//            print_r($data);
//            exit;
//            $data['child'] = $this->Customer->bonusMonthlyAchievers();
             $this->load->view("admin/bonusMonthlyAchievers", $data);
        }
    }

    public function salesHistory() {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Sales History";
            $thismonth = date('Y-m');
//            $config['enable_query_strings'] = true;
//            $config['base_url'] = base_url() . '/admin/salesHistory';
//            $config['per_page'] = 50;
//            $config['first_url'] = $config['base_url'] . '?' . http_build_query($_GET);
//            $config['suffix'] = '?' . http_build_query($_GET);
//            $config['total_rows'] = $this->Admin->getsalesHistoryLogCount($thismonth);
            if (isset($_GET["monthName"]) && isset($_GET["startDate"])) {
                $data['salesHistory'] = $this->Admin->salesHistory($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
//                $data['salesHistory'] = $this->Admin->salesHistory($config['per_page'], $page, $_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
//                $config['total_rows'] = $this->Admin->getsalesHistoryLogCountWhere($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
                $this->pagination->initialize($config);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {
                $this->pagination->initialize($config);
                $radio = "monthlyReport";
                $data['salesHistory'] = $this->Admin->salesHistory($radio, $thismonth);
            }
//            $data['paglink'] = $this->pagination->create_links();
//            $data['salesHistory'] = $this->Admin->salesHistory();
            $this->load->view("admin/salesHistory", $data);
        } else {
            redirect('admin/index');
        }
    }

    public function productHistory() {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Product History";
            $thismonth = date('Y-m');
            if (isset($_GET["monthName"]) && isset($_GET["startDate"])) {
//                echo '<pre>';
//                print_r($_GET['filter_radio']);
//                exit;
                if ($_GET['filter_radio'] == "") {
                    $_GET['filter_radio'] = "monthlyReport";
                }
                if ($_GET['paidUnpaid'] == "Paid") {
                    $_GET['paidUnpaid'] = 1;
                } else
                if ($_GET['paidUnpaid'] == "UnPaid") {
                    $_GET['paidUnpaid'] = 3;
                } else {
                    $_GET['paidUnpaid'] = 2;
                }

                $data['key'] = $_GET['paidUnpaid'];
                $data["monthName"] = $_GET["monthName"];
                $data['result'] = $this->Admin->get_Paid_UnPain_History($_GET['code'], $_GET['paidUnpaid'], $_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"]);
            } else {
                $data['key'] = 2;
                $radio = "monthlyReport";
                $data["monthName"] = date('Y-m');
                $data['result'] = $this->Admin->get_Paid_UnPain_History(null, null, $radio, $thismonth);
            }
            $this->load->view('admin/productHistory', $data);
        } else {
            redirect('admin/index');
        }
    }

    public function transferHistory($page = 0) {
        if ($this->session->userdata('admin_code')) {

            $this->pageHeading = "Transfer History";
            $thismonth = date('Y-m');
//            $config['enable_query_strings'] = true;
//            $config['base_url'] = base_url() . '/admin/transferHistory';
//            $config['per_page'] = 50;
//            $config['first_url'] = $config['base_url'] . '?' . http_build_query($_GET);
//            $config['suffix'] = '?' . http_build_query($_GET);
//            $config['total_rows'] = $this->Admin->getTransferHistoryLogCount();
//            $this->pagination->cur_page = $offset;
            //$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
            if ($this->input->get()) {
                $data['result'] = $this->Admin->transferHistory($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
//                $config['total_rows'] = $this->Admin->getTransferHistoryLogCountWhere($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
//                $this->pagination->initialize($config);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {
//                $this->pagination->initialize($config);
                $radio = "monthlyReport";
                $data['result'] = $this->Admin->transferHistory($radio, $thismonth);
            }
            $data['paglink'] = $this->pagination->create_links();
            $data['page_color'] = "transferHistory";
            $this->load->view('admin/transferHistory', $data);
        } else {
            redirect('admin/index');
        }
    }

    public function auditLog($page = 0) {
        if ($this->session->userdata("admin_code")) {
            $this->pageHeading = "Audit Log";
            $thismonth = date('Y-m');
//            $config['uri_segment'] = 3;
//            $config['use_page_numbers'] = true;
//            $config['enable_query_strings'] = true;
//            $config['base_url'] = base_url() . '/admin/auditLog';
//            $config['per_page'] = 50;
//            $config['first_url'] = $config['base_url'] . '?' . http_build_query($_GET);
//            $config['suffix'] = '?' . http_build_query($_GET);
//            $config['total_rows'] = $this->Admin->getAudiLogCount();
//            $this->pagination->cur_page = $offset;
            //$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
            if ($this->input->get()) {
                $data['result'] = $this->Admin->getAuditLog($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
//                $config['total_rows'] = $this->Admin->getAudiLogCountWhere($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
//                $this->pagination->initialize($config);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {
//                $this->pagination->initialize($config);
                $radio = "monthlyReport";
                $data['result'] = $this->Admin->getAuditLog($radio, $thismonth);
            }
            $data['paglink'] = $this->pagination->create_links();
            $data['page_color'] = "auditLog";
            $this->load->view('admin/auditLog', $data);
        } else {
            redirect("admin/index");
        }
    }

    public function bonusAuditLog($page = 0) {
        if ($this->session->userdata("admin_code")) {

            $this->pageHeading = "Bonus Audit Log";
            $thismonth = date('Y-m');
//            $config['uri_segment'] = 3;
//            $config['use_page_numbers'] = true;
//            $config['enable_query_strings'] = true;
//            $config['base_url'] = base_url() . '/admin/auditLog';
//            $config['per_page'] = 50;
//            $config['first_url'] = $config['base_url'] . '?' . http_build_query($_GET);
//            $config['suffix'] = '?' . http_build_query($_GET);
//            $config['total_rows'] = $this->Admin->getAudiLogCount();
//            $this->pagination->cur_page = $offset;
            //$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
            if ($this->input->get()) {
                $data['result'] = $this->Admin->getAuditLog($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"], "bonus");
//                $config['total_rows'] = $this->Admin->getAudiLogCountWhere($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
//                $this->pagination->initialize($config);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {
//                $this->pagination->initialize($config);
                $radio = "monthlyReport";
                $data['result'] = $this->Admin->getAuditLog($radio, $thismonth, null, null, null, 'bonus');
            }
            $data['paglink'] = $this->pagination->create_links();
            $data['page_color'] = "auditLog";
            $this->load->view('admin/auditLog', $data);
        } else {
            redirect("admin/index");
        }
    }

    public function directHistory($page = 0) {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Direct History";
            $thismonth = date('Y-m');
//            $config['enable_query_strings'] = true;
//            $config['base_url'] = base_url() . '/admin/directHistory';
//            $config['per_page'] = 50;
//            $config['first_url'] = $config['base_url'] . '?' . http_build_query($_GET);
//            $config['suffix'] = '?' . http_build_query($_GET);
//            $config['total_rows'] = $this->Admin->getDirectHistoryLogCount();
//            $this->pagination->cur_page = $offset;
            //$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
            if ($this->input->get()) {
                $data['result'] = $this->Admin->directHistory($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
//                $config['total_rows'] = $this->Admin->getDirectHistoryLogCountWhere($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
//                $this->pagination->initialize($config);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {

//                $this->pagination->initialize($config);
                $radio = "monthlyReport";
                $data['result'] = $this->Admin->directHistory($radio, $thismonth);
            }
            $data['paglink'] = $this->pagination->create_links();
            $data['page_color'] = "directHistory";
            $this->load->view('admin/directHistory', $data);
        } else {
            redirect('admin/index');
        }
    }

    public function flyUpHistory($page = 0) {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "FlyUp History";
            $thismonth = date('Y-m');
//            $config['enable_query_strings'] = true;
//            $config['base_url'] = base_url() . '/admin/flyUpHistory';
//            $config['per_page'] = 50;
//            $config['first_url'] = $config['base_url'] . '?' . http_build_query($_GET);
//            $config['suffix'] = '?' . http_build_query($_GET);
//            $config['total_rows'] = $this->Admin->getFlyupHistoryLogCount();
//            $this->pagination->cur_page = $offset;
            //$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
            if ($this->input->get()) {
                $data['result'] = $this->Admin->flyUpHistory($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
//                $config['total_rows'] = $this->Admin->getFlyupHistoryLogCountWhere($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
//                $this->pagination->initialize($config);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {
//                $this->pagination->initialize($config);
                $radio = "monthlyReport";
                $data['result'] = $this->Admin->flyUpHistory($radio, $thismonth);
            }
            $data['paglink'] = $this->pagination->create_links();
            $data['page_color'] = "flyUpHistory";
            $this->load->view('admin/flyUpHistory', $data);
        } else {
            redirect('admin/index');
        }
    }

    function DirectFlyUpBenefitHistory($page = 0) {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Direct And FlyUp Benefit History";
//            $thismonth = date('Y-m');
//            $config['enable_query_strings'] = true;
//            $config['base_url'] = base_url() . '/admin/DirectFlyUpBenefitHistory';
//            $config['per_page'] = 50;
//            $config['first_url'] = $config['base_url'] . '?' . http_build_query($_GET);
//            $config['suffix'] = '?' . http_build_query($_GET);
//            $config['total_rows'] = $this->Admin->getUserCodeCount();
//            $this->pagination->cur_page = $offset;
            //$page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
            if ($this->input->get()) {
                $data['result'] = $this->Admin->getUserCode();
//                $config['total_rows'] = $this->Admin->getUserCodeCount();
//                $this->pagination->initialize($config);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {
//                $this->pagination->initialize($config);
//                 $radio = "monthlyReport";
                $data["monthName"] = date('Y-m');
                $data["filter_radio"] = "monthlyReport";
                $data['result'] = $this->Admin->getUserCode();
            }
//            $data['paglink'] = $this->pagination->create_links();
            $data['page_color'] = "DirectFlyUpBenefitHistory";
            $this->load->view('admin/DirectFlyUpBenefitHistory', $data);
        } else {
            redirect('admin/index');
        }
    }

    public function admintransferhistory($msg = '') {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Admin Balance Transfer Report";
            $thismonth = date('Y-m');
            if ($this->input->get()) {
//                $usercode = $this->input->post('code');
                $data['transferhistory'] = $this->Admin->getadmintransferhistory($this->session->userdata('admin_code'), $_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"]);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
            } else {
                $radio = "monthlyReport";
                $data['transferhistory'] = $this->Admin->getadmintransferhistory($this->session->userdata('admin_code'), $radio, $thismonth);
            }
            $this->load->view('admin/admintransferhistory', $data);
        } else {
            redirect("admin/login");
        }
    }

    public function adminbalancehistory() {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Benefit Paid History";
            $thismonth = date('Y-m');
//            $data['report'] = $this->Admin->getadminpaymentlog($this->session->userdata('admin_code'));
//            $this->load->view('admin/adminbalancehistory', $data);
//            $config['uri_segment'] = 3;
//            $config['base_url'] = base_url() . '/admin/adminbalancehistory';
//            $config['per_page'] = '22';
//            $config['total_rows'] = $this->Customer->getAccountStatementCountByUserId($this->session->userdata("admin_code"));
//            $this->pagination->initialize($config);
//            $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
            if ($this->input->get()) {

                if ($_GET["paidUnpaid"] == 'UnPaid') {
                    $this->pageHeading = "Benefit Un-Paid History";
                }
                if ($_GET['filter_radio'] == "") {
                    $_GET['filter_radio'] = 'monthlyReport';
                }
//                $usercode = $this->input->post('code');
                $data['result'] = $this->Admin->getPaidHistory($_GET["filter_radio"], $_GET["monthName"], $_GET["startDate"], $_GET["endDate"], $_GET["code"], $_GET["paidUnpaid"]);
                $data["monthName"] = $_GET["monthName"];
                $data["startDate"] = date("Y-m-d", strtotime($_GET["startDate"]));
                $data["endDate"] = date("Y-m-d", strtotime($_GET["endDate"]));
                $data["filter_radio"] = $_GET["filter_radio"];
                $data['key'] = $_GET['paidUnpaid'];
                if ($_GET['paidUnpaid'] == "Paid") {
                    $_GET['paidUnpaid'] = 1;
                }
                if ($_GET['paidUnpaid'] == "UnPaid") {
                    $_GET['paidUnpaid'] = 3;
                }
            } else {
                $radio = "monthlyReport";
                $data['result'] = $this->Admin->getPaidHistory($radio, $thismonth);
            }
//            $data['paging_link'] = $this->pagination->create_links();
            $data['page_color'] = "adminbalancehistory";
            $this->load->view('admin/adminbalancehistory', $data);
        } else {
            redirect('admin/index');
        }
    }

    public function transferFunds($fromid = '') {
        if ($this->session->userdata('admin_code')) {
            $CI = get_instance();
            $this->pageHeading = "Transfer Funds";
            $user_info['user_info'] = $this->Admin->getAdminByCode($this->session->userdata("admin_code"));
            if ($this->input->post()) {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('rCode', 'Receiver Code', 'trim|required|xss_clean|max_length[20]');
                $this->form_validation->set_rules('trBy', 'Transfer By', 'trim|required|xss_clean|max_length[20]');
                $this->form_validation->set_rules('amount', 'Amount', 'trim|required|xss_clean|max_length[20]');
                $this->form_validation->set_rules('pin', 'Pin', 'trim|required|xss_clean|max_length[20]');
                if (!($this->form_validation->run() == FALSE)) {
                    if ($this->input->post('trFrom') != $this->input->post('rCode')) {
                        if ($user_info['user_info'][0]['pin'] == $this->input->post('pin')) {
                            $tr_from_code = "";
                            if (trim($this->input->post('trFrom')) != "") {
                                $transferFrom = $this->Customer->getUserByCode($this->input->post('trFrom'));
                                if (count($transferFrom) > 0 && $this->input->post('trFrom') != 1) {
                                    $tr_from_code = $this->input->post('trFrom');
                                } else {
                                    $user_info['error'] = "Transfer from user code is not correct!";
                                }
                            }
                            $receiver = $this->Customer->getUserByCode($this->input->post('rCode'));
                            if (count($receiver) > 0 && $this->input->post('rCode') != 1) {
                                if ($tr_from_code != "") {
                                    if ($transferFrom[0]['remaning_blance'] >= $this->input->post('amount')) {
                                        if ($this->input->post('amount') > 0) {
                                            $add_balance = array(
                                                'transfer_funds' => $receiver[0]['transfer_funds'] + $this->input->post('amount'),
                                                'remaning_blance' => $receiver[0]['remaning_blance'] + $this->input->post('amount'),
                                                'total_balance' => $receiver[0]['total_balance'] + $this->input->post('amount'),
                                            );
                                            $this->Customer->updateParentById($receiver[0]['user_code'], $add_balance);
                                            detectBalence($transferFrom[0]['user_code'], $this->input->post('amount'), $receiver[0]['user_code'], null, null, $this->input->post('trBy'));
                                            $payment_data = $this->Customer->getPaymentLogByUserid($receiver[0]['user_code']);

                                            if (count($payment_data) > 0) {
                                                $index = count($payment_data);
                                                $payment_log = array(
                                                    'user_id' => $receiver[0]['user_code'],
                                                    'balance_type' => $CI->balance_type[5],
                                                    'dabit' => $this->input->post('amount'),
                                                    'amount' => $payment_data[$index - 1]['amount'] + $this->input->post('amount'),
                                                    'date' => date('Y-m-d H:i:s'),
                                                    'benifit_from' => $transferFrom[0]['user_code'],
                                                    'type' => 22,
                                                    'paid_by' => $this->input->post('trBy'),
                                                );
                                            } else {
                                                $payment_log = array(
                                                    'user_id' => $receiver[0]['user_code'],
                                                    'balance_type' => $CI->balance_type[5],
                                                    'dabit' => $this->input->post('amount'),
                                                    'amount' => $this->input->post('amount'),
                                                    'date' => date('Y-m-d H:i:s'),
                                                    'benifit_from' => $transferFrom[0]['user_code'],
                                                    'type' => 22,
                                                    'paid_by' => $this->input->post('trBy'),
                                                );
                                            }
                                            $CI->Customer->createPaymentLog($payment_log);
                                            $user_info['success'] = "Transfer Amount Successfully!";
                                        } else {
                                            $user_info['error'] = "Amount Should Be Greater Than 0!";
                                        }
                                    } else {
                                        $user_info['error'] = "Amount exceed than available limit!";
                                    }
                                } else {
                                    if ($user_info['error'] == "") {
                                        if ($user_info['user_info'][0]['balance'] >= $this->input->post('amount')) {
                                            if ($this->input->post('amount') > 0) {
                                                $add_balance = array(
                                                    'transfer_funds' => $receiver[0]['transfer_funds'] + $this->input->post('amount'),
                                                    'remaning_blance' => $receiver[0]['remaning_blance'] + $this->input->post('amount'),
                                                    'total_balance' => $receiver[0]['total_balance'] + $this->input->post('amount'),
                                                );
                                                $this->Customer->updateParentById($receiver[0]['user_code'], $add_balance);
                                                $detectBalence = array(
                                                    'balance' => $user_info['user_info'][0]["balance"] - $this->input->post('amount')
                                                );
                                                $this->Admin->updateAdminByCode($user_info['user_info'][0]["user_code"], $detectBalence);
                                                $payment_data = $this->Customer->getPaymentLogByUserid($this->session->userdata('admin_code'));
                                                $index = 0;
                                                if (count($payment_data) > 0) {
                                                    $index = count($payment_data);
                                                    $admin_payment_log = array(
                                                        'user_id' => $this->session->userdata('admin_code'),
                                                        'balance_type' => "Admin transfer",
                                                        'amount' => $payment_data[$index - 1]['amount'] - $this->input->post('amount'),
                                                        'credit' => $this->input->post('amount'),
                                                        'date' => date('Y-m-d H:i:s'),
                                                        'type' => 20,
                                                        'benifit_from' => 0,
                                                        'benifit_to' => $this->input->post('rCode'),
                                                        'paid_by' => $this->input->post('trBy'),
                                                    );
                                                    $this->Admin->createAdminBalanceHistory($admin_payment_log);
                                                }
                                                paymentTransaction($receiver[0]['user_code'], $this->input->post('amount'));
                                                $user_info['success'] = "Amount Transfered Successfully!";
                                            } else {
                                                $user_info['error'] = "Amount Should Be Greater Than 0!";
                                            }
                                        } else {
                                            $user_info['error'] = "Amount exceed than available limit!";
                                        }
                                    }
                                }
                            } else {
                                $user_info['error'] = "Receiver code is not correct!";
                            }
                        } else {
                            $user_info['error'] = "Pin is not correct!";
                        }
                    } else {
                        $user_info['error'] = "Same account not allowed!";
                    }
                }
            }
            if ($fromid != '') {
                $user_info['tfrom'] = $fromid;
            }
            $this->load->view('admin/transferFunds', $user_info);
        } else {
            redirect('admin/index');
        }
    }

    public function resetDistPin() {
        if ($this->session->userdata('admin_code')) {
            $data = array();
            $this->pageHeading = "Reset Pin !";
            if ($this->input->post()) {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('ditCode', 'Distributor Code', 'trim|required|xss_clean|max_length[20]');
                $this->form_validation->set_rules('oldPin', 'Old Pin ', 'trim|required|xss_clean|max_length[20]');
                $this->form_validation->set_rules('newPin', 'New Pin', 'trim|required|xss_clean|max_length[20]');
                $this->form_validation->set_rules('conPin', 'Con Pin', 'trim|required|xss_clean|max_length[20]|matches[newPin]');
                if (!($this->form_validation->run() == FALSE)) {
                    $check_user = $this->Customer->getUserByCode($this->input->post('ditCode'));
                    if (count($check_user) > 0 && $this->input->post('ditCode') != 1) {
                        $check_pin = $this->Customer->checkOldPin($this->input->post('ditCode'), $this->input->post('oldPin'));
                        if (count($check_pin) > 0) {
                            $this->Customer->updateUserPin($this->input->post('ditCode'), $this->input->post('newPin'));
                            $data['success'] = "Change Pin Successfully!";
                        } else {
                            $data['error'] = "The Old Pin Is Incorrect!";
                        }
                    } else {
                        $data['error'] = "This user does not exist in our database!";
                    }
                }
            }
            $this->load->view('admin/resetDistPin', $data);
        } else {
            redirect('admin/index');
        }
    }

    public function renewalReport() {
        if ($this->session->userdata('admin_code')) {
            $data['result'] = $this->Customer->getUserExpire();
            $this->load->view('admin/renewalReport', $data);
        } else {
            redirect('admin/index');
        }
    }

    public function payProduct($id) {
        if ($this->session->userdata('admin_code')) {
            if (trim($id) != "") {
                $data['result'] = $this->Admin->getProductHistory($id);
                if (count($data['result']) > 0) {
                    if ($this->input->post()) {
                        if ($data['result'][0]['is_paid'] != 1) {
                            $this->load->library('form_validation');
                            $this->form_validation->set_rules('rname', 'Receiver Name', 'trim|required|xss_clean|max_length[20]');
                            $this->form_validation->set_rules('payBy', 'Pay By', 'trim|required|xss_clean');
                            if (!($this->form_validation->run() == FALSE)) {
                                $update_product_history = array(
                                    'resiver_name' => $this->input->post('rname'),
                                    'is_paid' => 1,
                                    'paid_date' => date('Y-m-d h:i:s'),
                                    'paid_by' => $this->input->post('payBy')
                                );
                                $this->Admin->updateProductHistory($data['result'][0]['id'], $update_product_history);
                                $data['success'] = "Product Paid to distributor successfully!";
                            }
                        } else {
                            $data['success'] = "Already paid!";
                        }
                    }
                    $this->load->view('admin/payProduct', $data);
                }
            }
        } else {
            redirect('admin/index');
        }
    }

    public function eMoneyIssue($mName = "", $sDate = "", $eDate = "", $fRadio = "") {
        $this->pageHeading = "E-Money Issued";
        $data['result'] = $this->Admin->eMoneyIssue($fRadio, $mName, $sDate, $eDate);
        $this->load->view('admin/eMoneyIssue', $data);
    }

    public function eMoneyUsed($mName = "", $sDate = "", $eDate = "", $fRadio = "") {
        $this->pageHeading = "E-Money Used";
        $data['result'] = $this->Admin->eMoneyUsed($fRadio, $mName, $sDate, $eDate);
        $this->load->view('admin/eMoneyUsed', $data);
    }

    public function eMoneyUnused($mName = "", $sDate = "", $eDate = "", $fRadio = "") {
        $this->pageHeading = "E-Money Pending";
        $data['result'] = $this->Admin->eMoneyUnused($fRadio, $mName, $sDate, $eDate);
        $this->load->view('admin/eMoneyUnused', $data);
    }

//    public function resetDistPin(){
//      if($this->session->userdata('admin_code'))
//      {
//          
//      }
//      else{
//          redirect('admin/index');
//      }
//    }
    public function unauthorized() {
        if ($this->session->userdata('admin_code')) {
            $this->pageHeading = "Un-Authorized Access";
            $startDate = '';
            $endDate = '';
            $data["monthName"] = date("Y-m");
            if ($this->input->get()) {
                $data["monthName"] = $this->input->get('monthName');
                if ($this->input->get('filter_radio') == 'monthlyReport') {
                    $code = $this->input->get('code');
                    $monthlyReport = $this->input->get('filter_radio');
                    $monthName = $this->input->get('monthName');
                    if ($monthName == 'all') {
                        $startDate = date("2014-02-01");
                        $endDate = date("Y-m-d", time() + 86400);
                    } else {
                        $startDate = $monthName . "-01";
                        $endDate = $monthName . "-30";
                    }
                } else {
                    $startDate = $this->input->get('startDate');
                    $endDate = $this->input->get('endDate');
                }
            }
            $data['report'] = $this->Admin->getunauthorizedreport($code, $startDate, $endDate);
            $this->load->view('admin/unauthorized', $data);
        } else {
            redirect("admin/login");
        }
    }

    public function logout() {

        $this->session->unset_userdata('admin_code');
        redirect('admin/home');
    }

}
